/***************************************************************************

                   tenses of irreg. verbs dialog page

    -----------------------------------------------------------------------

    begin          : Sat Nov 27 20:20:34 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TenseEntryPage_included
#define TenseEntryPage_included

#include "TenseEntryPageForm.h"

#include <grammarmanager.h>

class EntryDlg;

class TenseEntryPage : public TenseEntryPageForm
{
  TQ_OBJECT
  

public:
  TenseEntryPage
  (
    EntryDlg          *dlgbook,
    bool               multi_sel,
    const Conjugation &con_prefix,
    const Conjugation &conjugations,
    TQWidget           *parent = NULL,
    const char        *name = NULL
  );

  void setData(bool multi_sel, const Conjugation &conjugations);

  Conjugation getConjugation();

  bool isModified();
  void setModified(bool mod = true);
  void setEnabled(int enable_type);

signals:
  void sigModified();

protected:
  void updateFields();

protected slots:
  void secondPluralChanged(const TQString&);
  void secondSingularChanged(const TQString&);
  void thirdNSingularChanged(const TQString&);
  void thirdFPluralChanged(const TQString&);
  void thirdMSingularChanged(const TQString&);
  void thirdFSingularChanged(const TQString&);
  void slotTenseSelected(int);
  void thirdMPluralChanged(const TQString&);
  void thirdNPluralChanged(const TQString&);
  void firstSingularChanged(const TQString&);
  void firstPluralChanged(const TQString&);
  void slotThirdSCommonToggled(bool);
  void slotThirdPCommonToggled(bool);
  void slotNextConj();

protected:
  Conjugation   prefix,
                conjugations;
  TQString       selection;
  bool          multi_mode;
  bool          modified;
  EntryDlg     *dlgbook;
};

#endif // TenseEntryPage_included
