/***************************************************************************
 *   Copyright (C) 2003 by Julian Rockey (kde@jrockey.com)                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __importedmodules_h__
#define __importedmodules_h__

#include <Python.h>

namespace PythonDCOP {

  /**
   * Manages imported Python modules.
   */
  class ImportedModules {
  public:
    ImportedModules();
    ~ImportedModules();
    PyObject *createDCOPObject( const char* appname, const char* objname );
    PyObject *dcop_module() const { return m_dcop_module; }

    static ImportedModules *instance() { return m_instance; }
    static void setInstance(ImportedModules *instance) { m_instance = instance; }

  private:
    PyObject *m_dcop_module;
    static ImportedModules *m_instance;
  };

}

#endif
