/***************************************************************************
 *   Copyright (C) 2004 by Hans Oischinger                                 *
 *   hans.oischinger@kde-mail.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kompose.h"
#include "komposeglobal.h"

#include <stdlib.h>

#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>


static const char description[] = 
  I18N_NOOP("A fullscreen task manager for TDE");

static const char version[] = "0.5.4";

static TDECmdLineOptions options[] =
  {
    { "nosystray", I18N_NOOP( "Do not show the systray icon" ), 0 },
    { "singleshot", I18N_NOOP( "Display the default view and exit (non daemon mode)" ), 0 },
    TDECmdLineLastOption
  };

void myMessageOutput( TQtMsgType type, const char *msg )
{
  return;
  switch ( type )
  {
  case TQtDebugMsg:
    fprintf( stderr, "Debug: %s\n", msg );
    break;
  case TQtWarningMsg:
    fprintf( stderr, "Warning: %s\n", msg );
    break;
  case TQtFatalMsg:
    fprintf( stderr, "Fatal: %s\n", msg );
    abort();                    // deliberately core dump
  }
}

int main(int argc, char **argv)
{
//   qInstallMsgHandler( myMessageOutput );
  
  TDEAboutData about("kompose", I18N_NOOP("Komposé"), version, description, TDEAboutData::License_GPL,
    "Copyright (c) 2021, The Trinity Desktop project\nCopyright (c) 2005, Hans Oischinger", "", "https://www.trinitydesktop.org/" );
  about.addAuthor( "Hans Oischinger", "Original Author", "hans.oischinger@kde-mail.net", "http://developer.berlios.de/projects/kompose" );
  TDECmdLineArgs::init(argc, argv, &about);
  TDECmdLineArgs::addCmdLineOptions( options );

  Kompose *app = new Kompose();

  // no session.. just start up normally
  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
  
  if ( !args->isSet("systray") )
  {
    KomposeGlobal::instance()->setHideSystray(true);
  }
  if ( args->isSet("singleshot") )
  {
    KomposeGlobal::instance()->setHideSystray(true);
    KomposeGlobal::instance()->setSingleShot(true);
  }

  KomposeGlobal::instance()->initGui();
  
  //app.setMainWidget( mainWin );

  args->clear();

  // mainWin has WDestructiveClose flag by default, so it will delete itself.
  return app->exec();
}

