//
// C++ Implementation: komposepreferences
//
// Description:
//
//
// Author: Hans Oischinger <hans.oischinger@kde-mail.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "komposepreferences.h"

#include "komposesettings.h"
#include "komposeglobal.h"

#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tdeapplication.h>
#include <tqwhatsthis.h>
#include <tqtooltip.h>
#include <tqspinbox.h>
#include <tqgroupbox.h>
#include <tqbuttongroup.h>
#include <tqhbox.h>
#include <tqslider.h>
#include <tqpushbutton.h>
#include <tqgrid.h>
#include <tqvgroupbox.h>
#include <tqradiobutton.h>
#include <tqcombobox.h>

#include <kiconloader.h>
#include <kcolorbutton.h>
#include <tdefontdialog.h>

KomposePreferences::KomposePreferences()
    : KDialogBase(IconList, i18n("Komposé Preferences"), Ok|Apply|Cancel, Ok)
{
  // FIXME: this is the biggest constructor I've EVER written!
  // How about TQt Designer?!
  m_hasXinerama = TQDesktopWidget().numScreens() > 1;

  TQFrame *page1 = addPage( i18n("Behavior"), TQString::null, DesktopIcon("kompose", TDEIcon::SizeMedium) );
  TQFrame *page2 = addPage( i18n("Appearance"), TQString::null, DesktopIcon("preferences-desktop", TDEIcon::SizeMedium) );
  TQFrame *page3 = addPage( i18n("Layouts"), TQString::null, DesktopIcon("window_duplicate", TDEIcon::SizeMedium) );

  TQVBoxLayout *page1Layout = new TQVBoxLayout( page1, 0, KDialog::spacingHint() );

  defaultViewBtnGroup = new TQButtonGroup( 2, Horizontal, i18n("Default Layout"), page1 );
  defaultViewBtnGroup->setExclusive( true );
  TQString defaultViewBtnGroupHelp = i18n("Determines which view should be started by default (e.g. when you click on the systray icon).");
  TQWhatsThis::add( defaultViewBtnGroup, defaultViewBtnGroupHelp );
  TQToolTip::add( defaultViewBtnGroup, defaultViewBtnGroupHelp );
  defaultViewWorld = new TQRadioButton(i18n("Ungrouped"), defaultViewBtnGroup );
  TQString defaultViewWorldHelp = i18n("Fullscreen layout that shows all windows in no specific order");
  TQWhatsThis::add( defaultViewWorld, defaultViewWorldHelp );
  TQToolTip::add( defaultViewWorld, defaultViewWorldHelp );
  defaultViewVirtualDesks = new TQRadioButton(i18n("Grouped by virtual desktops"), defaultViewBtnGroup );
  TQString defaultViewVirtualDesksHelp = i18n("Fullscreen layout that shows a representation of your virtual desktops\n and places the windows inside.");
  TQWhatsThis::add( defaultViewVirtualDesks, defaultViewVirtualDesksHelp );
  TQToolTip::add( defaultViewVirtualDesks, defaultViewVirtualDesksHelp );
  defaultViewCurrentDesk = new TQRadioButton(i18n("Current virtual desktop"), defaultViewBtnGroup );
  TQString defaultViewCurrentDeskHelp = i18n("Fullscreen layout that shows the windows of the desktop you're currently working on.");
  TQWhatsThis::add( defaultViewCurrentDesk, defaultViewCurrentDeskHelp );
  TQToolTip::add( defaultViewCurrentDesk, defaultViewCurrentDeskHelp );
  page1Layout->addWidget(defaultViewBtnGroup);

  if (m_hasXinerama)
  {
    TQGroupBox *xineramaGroupBox = new TQGroupBox( 2, Vertical, i18n("Xinerama"), page1 );

    TQDesktopWidget deskwidget;
    m_viewScreenAll = new TQCheckBox(i18n("Use the whole desktop for Komposé"), xineramaGroupBox);

    TQHBox *hLayXineramaGrabDelay = new TQHBox(xineramaGroupBox);
    TQLabel *xineramaLabel = new TQLabel(i18n("Use screen:"), hLayXineramaGrabDelay);
    m_viewScreen = new TQSpinBox(0, deskwidget.numScreens()-1, 1, hLayXineramaGrabDelay);
    connect( m_viewScreenAll, TQ_SIGNAL(toggled(bool)), m_viewScreen, TQ_SLOT(setDisabled(bool)) );
    xineramaLabel->setBuddy(m_viewScreen);
    TQString xineramaHelp = i18n("Specify the screen where Komposé should appear." );
    TQWhatsThis::add( m_viewScreen, xineramaHelp );
    TQToolTip::add( m_viewScreen, xineramaHelp );
    TQWhatsThis::add( xineramaLabel, xineramaHelp );
    TQToolTip::add( xineramaLabel, xineramaHelp );

    page1Layout->addWidget(xineramaGroupBox);
  }

#ifdef COMPOSITE
  TQGroupBox *screenshotsGroupBox = new TQGroupBox( 4, Vertical, i18n("Screenshots"), page1 );

  useComposite = new TQCheckBox(i18n("Use XComposite if available"), screenshotsGroupBox);
  TQString useCompositeHelp = i18n("Making use of the Composite extension of newer X Servers makes the grabbing of screenshots obsolete.\nThe contents of all windows are drawn in back buffers that will be accessed by Komposé\nNote that the Composite implementation of even modern graphic card drivers is still very slow and may make your system pretty unusable.");
  TQWhatsThis::add( useComposite, useCompositeHelp );
  TQToolTip::add( useComposite, useCompositeHelp );
  connect( useComposite, TQ_SIGNAL(toggled(bool)), TQ_SLOT(setUseCompositeToggled(bool)) );
#else
  TQGroupBox *screenshotsGroupBox = new TQGroupBox( 3, Vertical, i18n("Screenshots"), page1 );
#endif

  passiveScreenshots = new TQCheckBox(i18n("Passive screenshots"), screenshotsGroupBox);
  TQString passiveScreenshotsHelp = i18n("Create a screenshot whenever you raise or active a window.\nWhen selected the amount the annoying popup-effect before every Komposé activation will be minimized to nearly zero.\nThe drawback is that the screenshots are not so recent and may not display the actual content.");
  TQWhatsThis::add( passiveScreenshots, passiveScreenshotsHelp );
  TQToolTip::add( passiveScreenshots, passiveScreenshotsHelp );

  TQHBox *hLayScreenshotGrabDelay = new TQHBox(screenshotsGroupBox);
  TQLabel *screenshotGrabDelayLabel = new TQLabel(i18n("Delay between screenshots (ms):"), hLayScreenshotGrabDelay);
  screenshotGrabDelay = new TQSpinBox(0, 999, 10, hLayScreenshotGrabDelay);
  screenshotGrabDelayLabel->setBuddy(screenshotGrabDelay);
  TQString screenshotGrabDelayHelp = i18n("Specifies the time to wait between the activation of a window and the screenshot taking.\nIncrease it when your windows need more time to draw themselves after activation.\nValues below 300ms are not recommended, but may work in some cases." );
  TQWhatsThis::add( screenshotGrabDelay, screenshotGrabDelayHelp );
  TQToolTip::add( screenshotGrabDelay, screenshotGrabDelayHelp );
  TQWhatsThis::add( screenshotGrabDelayLabel, screenshotGrabDelayHelp );
  TQToolTip::add( screenshotGrabDelayLabel, screenshotGrabDelayHelp );

  cacheScaledPixmaps = new TQCheckBox(i18n("Cache scaled Screenshots"), screenshotsGroupBox);
  TQString cacheScaledPixmapsHelp = i18n("This may avoid some scaling operations to be called repeatedly when Komposé has been displayed before and the screenshot's size didn't change.\nIt will however increase memory usage quite a bit.");
  TQWhatsThis::add( cacheScaledPixmaps, cacheScaledPixmapsHelp );
  TQToolTip::add( cacheScaledPixmaps, cacheScaledPixmapsHelp );

  page1Layout->addWidget(screenshotsGroupBox);


  // Autolock
  TQGroupBox* autoLockGroup = new TQGroupBox( 0, TQt::Horizontal, i18n("Autoactivate when mouse moves into"), page1 );
  TQGridLayout* autoLockLayout = new TQGridLayout( autoLockGroup->layout(), 5, 2, KDialog::spacingHint() );
  m_topLeftCorner = new TQCheckBox( i18n("Top-left corner"), autoLockGroup);
  autoLockLayout->addWidget( m_topLeftCorner, 0, 0 );
  m_topRightCorner = new TQCheckBox( i18n("Top-right corner"), autoLockGroup );
  autoLockLayout->addWidget( m_topRightCorner, 1, 0 );
  m_bottomLeftCorner = new TQCheckBox( i18n("Bottom-left corner"), autoLockGroup );
  autoLockLayout->addWidget( m_bottomLeftCorner, 2, 0 );
  m_bottomRightCorner = new TQCheckBox( i18n("Bottom-right corner"), autoLockGroup );
  autoLockLayout->addWidget( m_bottomRightCorner, 3, 0 );

  m_topEdge = new TQCheckBox( i18n("Top edge"), autoLockGroup);
  autoLockLayout->addWidget( m_topEdge, 0, 1 );
  m_bottomEdge = new TQCheckBox( i18n("Bottom edge"), autoLockGroup );
  autoLockLayout->addWidget( m_bottomEdge, 1, 1 );
  m_leftEdge = new TQCheckBox( i18n("Left edge"), autoLockGroup );
  autoLockLayout->addWidget( m_leftEdge, 2, 1 );
  m_rightEdge = new TQCheckBox( i18n("Right edge"), autoLockGroup );
  autoLockLayout->addWidget( m_rightEdge, 3, 1 );

  TQHBox *hLayAutoLockDelay = new TQHBox(autoLockGroup);
  TQLabel *autoLockDelayLabel = new TQLabel(i18n("Delay until activation (ms):"), hLayAutoLockDelay);
  autoLockDelay = new TQSpinBox(0, 5000, 10, hLayAutoLockDelay);
  autoLockDelayLabel->setBuddy(autoLockDelay);
  TQString autoLockDelayHelp = i18n("Specifies the time in ms for which the mouse pointer must rest in the corner until auto-activation." );
  TQWhatsThis::add( autoLockDelay, autoLockDelayHelp );
  TQToolTip::add( autoLockDelay, autoLockDelayHelp );
  TQWhatsThis::add( autoLockDelayLabel, autoLockDelayHelp );
  TQToolTip::add( autoLockDelayLabel, autoLockDelayHelp );
  autoLockLayout->addMultiCellWidget( hLayAutoLockDelay, 4, 4, 0, 1 );

  page1Layout->addWidget(autoLockGroup);

  page1Layout->insertStretch(-1);



  TQVBoxLayout *page2Layout = new TQVBoxLayout( page2, 0, KDialog::spacingHint() );

  imageEffects = new TQCheckBox(i18n("Enable image effects"), page2);
  TQString imageEffectsHelp = i18n("Lighten windows when the mouse moves over it or gray out minimized windows.\nDepending on your system specs this can be a bit slower." );
  TQWhatsThis::add( imageEffects, imageEffectsHelp );
  TQToolTip::add( imageEffects, imageEffectsHelp );
  page2Layout->addWidget(imageEffects);

  blurBackground = new TQCheckBox(i18n("Blur desktop background"), page2);
  TQString blurBackgroundHelp = i18n("Apply a Gaussian blur to the desktop background.\nMight make your machine considerably slower.");
  TQWhatsThis::add( blurBackground, blurBackgroundHelp );
  TQToolTip::add( blurBackground, blurBackgroundHelp );
  page2Layout->addWidget(blurBackground);

  showDesktopNum = new TQCheckBox(i18n("Show Desktop number on Systray icon"), page2);
  TQString showDesktopNumHelp = i18n("Displays the number of the currently active Desktop on the Komposé systray icon." );
  TQWhatsThis::add( showDesktopNum, showDesktopNumHelp );
  TQToolTip::add( showDesktopNum, showDesktopNumHelp );
  page2Layout->addWidget(showDesktopNum);

  TQGroupBox *windowTitleGroupBox = new TQGroupBox( 3, Vertical, i18n("Window Titles"), page2 );

  TQHBox *hBoxWindowTitles = new TQHBox(windowTitleGroupBox);
  showWindowTitles = new TQCheckBox(i18n("Show window titles"), hBoxWindowTitles);
  windowTitleFontBtn = new TQPushButton(i18n("Select Font..."), hBoxWindowTitles);
  TQString showWindowTitlesHelp = i18n( "Display the name of every window in Komposé" );
  TQWhatsThis::add( showWindowTitles, showWindowTitlesHelp );
  TQToolTip::add( showWindowTitles, showWindowTitlesHelp );
  connect( showWindowTitles, TQ_SIGNAL(toggled(bool)), windowTitleFontBtn, TQ_SLOT(setEnabled(bool)) );
  connect( windowTitleFontBtn, TQ_SIGNAL(clicked()), this, TQ_SLOT(showWindowTitleFontDialog()) );

  TQGrid *gridWindowTitlesColor = new TQGrid(2, windowTitleGroupBox);
  // windowTitleFontColorLabel = new TQLabel(windowTitleFontColor, i18n("Text color: "), gridWindowTitlesColor); // FIXME: How to link to a buddy that doesn't yet exist?
  windowTitleFontColorLabel = new TQLabel(i18n("Text color:"), gridWindowTitlesColor);
  windowTitleFontColor = new KColorButton(TQt::black, gridWindowTitlesColor);
  connect( showWindowTitles, TQ_SIGNAL(toggled(bool)), windowTitleFontColorLabel, TQ_SLOT(setEnabled(bool)) );
  connect( showWindowTitles, TQ_SIGNAL(toggled(bool)), windowTitleFontColor, TQ_SLOT(setEnabled(bool)) );
  showWindowTitleShadow = new TQCheckBox(i18n("Shadow color:"), gridWindowTitlesColor);
  windowTitleFontShadowColor = new KColorButton(TQt::lightGray, gridWindowTitlesColor);
  connect( showWindowTitles, TQ_SIGNAL(toggled(bool)), showWindowTitleShadow, TQ_SLOT(setEnabled(bool)) );
  connect( showWindowTitles, TQ_SIGNAL(toggled(bool)), windowTitleFontShadowColor, TQ_SLOT(setEnabled(bool)) );
  connect( showWindowTitleShadow, TQ_SIGNAL(toggled(bool)), windowTitleFontShadowColor, TQ_SLOT(setEnabled(bool)) );

  page2Layout->addWidget(windowTitleGroupBox);

  // see komposetaskwidget.cpp:207
  TQGroupBox *windowBorderGroupBox = new TQGroupBox( 2, Vertical, i18n("Window Border"), page2 );
  TQGrid *gridWindowBorderOpts = new TQGrid(2, windowBorderGroupBox);
  windowBorderActiveColorLabel = new TQLabel(i18n("Active border color:"), gridWindowBorderOpts);
  windowBorderActiveColor = new KColorButton(TQt::black, gridWindowBorderOpts);
  windowBorderActiveStyleLabel = new TQLabel(i18n("Active border style:"), gridWindowBorderOpts);
  TQHBox *hBoxWindowBorderActiveStyle = new TQHBox(gridWindowBorderOpts);
  windowBorderActiveWidth = new TQSpinBox(1, 255, 1, hBoxWindowBorderActiveStyle);
  windowBorderActiveWidth->setSuffix("px");
  windowBorderActiveStyle = new TQComboBox(false, hBoxWindowBorderActiveStyle);
  windowBorderActiveStyle->insertItem(i18n("None"));
  windowBorderActiveStyle->insertItem(i18n("Solid"));
  windowBorderActiveStyle->insertItem(i18n("Dashed"));
  windowBorderActiveStyle->insertItem(i18n("Dotted"));
  windowBorderActiveStyle->insertItem(i18n("Dash-Dot"));
  windowBorderActiveStyle->insertItem(i18n("Dash-Dot-Dot"));

  windowBorderInactiveColorLabel = new TQLabel(i18n("Inctive border color:"), gridWindowBorderOpts);
  windowBorderInactiveColor = new KColorButton(TQt::gray, gridWindowBorderOpts);
  windowBorderInactiveStyleLabel = new TQLabel(i18n("Inactive border style:"), gridWindowBorderOpts);
  TQHBox *hBoxWindowBorderInactiveStyle = new TQHBox(gridWindowBorderOpts);
  windowBorderInactiveWidth = new TQSpinBox(1, 255, 1, hBoxWindowBorderInactiveStyle);
  windowBorderInactiveWidth->setSuffix("px");
  windowBorderInactiveStyle = new TQComboBox(false, hBoxWindowBorderInactiveStyle);
  windowBorderInactiveStyle->insertItem(i18n("None"));
  windowBorderInactiveStyle->insertItem(i18n("Solid"));
  windowBorderInactiveStyle->insertItem(i18n("Dashed"));
  windowBorderInactiveStyle->insertItem(i18n("Dotted"));
  windowBorderInactiveStyle->insertItem(i18n("Dash-Dot"));
  windowBorderInactiveStyle->insertItem(i18n("Dash-Dot-Dot"));

  page2Layout->addWidget(windowBorderGroupBox);



  TQGroupBox *iconGroupBox = new TQGroupBox( 3, Vertical, i18n("Task Icons"), page2 );
  showIcons = new TQCheckBox(i18n("Show icons"), iconGroupBox);
  iconSize = new TQSlider(0, 3, 1, 0, TQt::Horizontal, iconGroupBox);
  iconSizeDescription = new TQLabel( iconSize, "", iconGroupBox);
  connect( iconSize, TQ_SIGNAL( sliderMoved(int) ), this, TQ_SLOT( updateIconSliderDesc(int) ) );
  connect( iconSize, TQ_SIGNAL( valueChanged(int) ), this, TQ_SLOT( updateIconSliderDesc(int) ) );
  connect( showIcons, TQ_SIGNAL( toggled(bool) ), iconSize, TQ_SLOT( setEnabled(bool) ) );
  connect( showIcons, TQ_SIGNAL( toggled(bool) ), iconSizeDescription, TQ_SLOT( setEnabled(bool) ) );
  page2Layout->addWidget(iconGroupBox);

  page2Layout->insertStretch(-1);



  TQVBoxLayout *page3Layout = new TQVBoxLayout( page3, 0, KDialog::spacingHint() );

  TQVGroupBox *virtDesksLayoutGroupBox = new TQVGroupBox( i18n("Grouped by Virtual Desktops"), page3 );
  /*
  dynamicVirtDeskLayout = new TQCheckBox(i18n("Layout empty virtual desktops minimized"), virtDesksLayoutGroupBox );
  TQString dynamicVirtDeskLayoutHelp = i18n("Check this if you want empty virtual desktops to take less space on the screen.\nUncheck it if you want them to be arranged statically, each of the same size.");
  TQWhatsThis::add( dynamicVirtDeskLayout, dynamicVirtDeskLayoutHelp );
  TQToolTip::add( dynamicVirtDeskLayout, dynamicVirtDeskLayoutHelp );
  */

  TQGrid *desktopColorsGroupBox = new TQGrid( 2, virtDesksLayoutGroupBox );
  desktopColorsGroupBox->setSpacing( 4 );
  desktopTitleFontColorLabel = new TQLabel(i18n("Desktop frame color:"), desktopColorsGroupBox);
  desktopTitleFontColor = new KColorButton(TQt::black, desktopColorsGroupBox);
  desktopTitleFontHighlightColorLabel = new TQLabel(i18n("Desktop frame highlight color:"), desktopColorsGroupBox);
  desktopTitleFontHighlightColor = new KColorButton(TQt::black, desktopColorsGroupBox);

  page3Layout->addWidget(virtDesksLayoutGroupBox);

  desktopTitleFontBtn = new TQPushButton(i18n("Select Desktop Names Font..."), virtDesksLayoutGroupBox);
  connect( desktopTitleFontBtn, TQ_SIGNAL(clicked()), this, TQ_SLOT(showDesktopTitleFontDialog()) );

  page3Layout->insertStretch(-1);


  fillPages();
}


KomposePreferences::~KomposePreferences()
{}

void KomposePreferences::updateIconSliderDesc( int val )
{
  switch( val )
  {
  case 0:
    iconSizeDescription->setText( i18n("16x16") );
    break;
  case 1:
    iconSizeDescription->setText( i18n("32x32") );
    break;
  case 2:
    iconSizeDescription->setText( i18n("64x64") );
    break;
  case 3:
    iconSizeDescription->setText( i18n("Don't scale, show as they are (preferably bigger)") );
    break;
  }
}

void KomposePreferences::showWindowTitleFontDialog()
{
  TDEFontDialog::getFont( *windowTitleFont );
  // if ( result == TDEFontDialog::Accepted )
}

void KomposePreferences::showDesktopTitleFontDialog()
{
  TDEFontDialog::getFont( *desktopTitleFont );
}

void KomposePreferences::fillPages()
{
  // Sync Settings to Preferences dialog
  switch ( KomposeSettings::instance()->getDefaultView() )
  {
  case KOMPOSEDISPLAY_VIRTUALDESKS:
    defaultViewVirtualDesks->setChecked( true );
    break;
  case KOMPOSEDISPLAY_WORLD:
    defaultViewWorld->setChecked( true );
    break;
  case KOMPOSEDISPLAY_CURRENTDESK:
    defaultViewCurrentDesk->setChecked( true );
    break;
  }

#ifdef COMPOSITE
  useComposite->setChecked( KomposeSettings::instance()->getUseComposite() );
#endif
  passiveScreenshots->setChecked( KomposeSettings::instance()->getPassiveScreenshots() );
  screenshotGrabDelay->setValue( KomposeSettings::instance()->getScreenshotGrabDelay() / 1000000 );
  cacheScaledPixmaps->setChecked( KomposeSettings::instance()->getCacheScaledPixmaps() );
  // dynamicVirtDeskLayout->setChecked( KomposeSettings::instance()->getDynamicVirtDeskLayout() );

  imageEffects->setChecked( KomposeSettings::instance()->getImageEffects() );
  blurBackground->setChecked( KomposeSettings::instance()->getBlurBackground() );

  showDesktopNum->setChecked( KomposeSettings::instance()->getShowDesktopNum() );

  showWindowTitles->setChecked( KomposeSettings::instance()->getShowWindowTitles() );
  windowTitleFont = new TQFont(KomposeSettings::instance()->getWindowTitleFont());
  windowTitleFontColor->setColor( KomposeSettings::instance()->getWindowTitleFontColor() );
  windowTitleFontShadowColor->setColor( KomposeSettings::instance()->getWindowTitleFontShadowColor() );
  showWindowTitleShadow->setChecked( KomposeSettings::instance()->getShowWindowTitleShadow() );
  // Disable dependant widgets
  windowTitleFontBtn->setEnabled( KomposeSettings::instance()->getShowWindowTitles() );
  windowTitleFontColorLabel->setEnabled( KomposeSettings::instance()->getShowWindowTitles() );
  windowTitleFontColor->setEnabled( KomposeSettings::instance()->getShowWindowTitles() );
  showWindowTitleShadow->setEnabled( KomposeSettings::instance()->getShowWindowTitles() );
  windowTitleFontShadowColor->setEnabled( KomposeSettings::instance()->getShowWindowTitles() || KomposeSettings::instance()->getShowWindowTitleShadow() );

  windowBorderActiveColor->setColor( KomposeSettings::instance()->getWindowBorderActiveColor() );
  windowBorderInactiveColor->setColor( KomposeSettings::instance()->getWindowBorderInactiveColor() );
  windowBorderActiveWidth->setValue( KomposeSettings::instance()->getWindowBorderActiveWidth() );
  windowBorderInactiveWidth->setValue( KomposeSettings::instance()->getWindowBorderInactiveWidth() );
  windowBorderActiveStyle->setCurrentItem( KomposeSettings::instance()->getWindowBorderActiveStyle() );
  windowBorderInactiveStyle->setCurrentItem( KomposeSettings::instance()->getWindowBorderInactiveStyle() );

  desktopTitleFont = new TQFont(KomposeSettings::instance()->getDesktopTitleFont());
  desktopTitleFontColor->setColor( KomposeSettings::instance()->getDesktopTitleFontColor() );
  desktopTitleFontHighlightColor->setColor( KomposeSettings::instance()->getDesktopTitleFontHighlightColor() );

  showIcons->setChecked( KomposeSettings::instance()->getShowIcons() );
  iconSize->setValue( KomposeSettings::instance()->getIconSize() );
  iconSize->setEnabled( showIcons->isChecked() );
  iconSizeDescription->setEnabled( showIcons->isChecked() );
  updateIconSliderDesc( iconSize->value() );

  m_topLeftCorner->setChecked( KomposeSettings::instance()->getActivateOnTopLeftCorner() );
  m_bottomLeftCorner->setChecked( KomposeSettings::instance()->getActivateOnBottomLeftCorner() );
  m_topRightCorner->setChecked( KomposeSettings::instance()->getActivateOnTopRightCorner() );
  m_bottomRightCorner->setChecked( KomposeSettings::instance()->getActivateOnBottomRightCorner() );

  m_topEdge->setChecked( KomposeSettings::instance()->getActivateOnTopEdge() );
  m_bottomEdge->setChecked( KomposeSettings::instance()->getActivateOnBottomEdge() );
  m_rightEdge->setChecked( KomposeSettings::instance()->getActivateOnRightEdge() );
  m_leftEdge->setChecked( KomposeSettings::instance()->getActivateOnLeftEdge() );
  autoLockDelay->setValue( KomposeSettings::instance()->getAutoLockDelay() );

  if (m_hasXinerama)
  {
    m_viewScreenAll->setChecked( KomposeSettings::instance()->getViewScreen() == -1 );
    if (KomposeSettings::instance()->getViewScreen() >= 0 )
      m_viewScreen->setValue( KomposeSettings::instance()->getViewScreen() );
    m_viewScreen->setDisabled( m_viewScreenAll->isChecked() );
  }
}




void KomposePreferences::slotApply()
{
  KomposeSettings::instance()->setDefaultView( defaultViewBtnGroup->selectedId() );

#ifdef COMPOSITE
  KomposeSettings::instance()->setUseComposite( useComposite->isChecked() );
#endif

  KomposeSettings::instance()->setPassiveScreenshots( passiveScreenshots->isChecked() );
  KomposeSettings::instance()->setScreenshotGrabDelay( screenshotGrabDelay->value() * 1000000 );
  KomposeSettings::instance()->setCacheScaledPixmaps( cacheScaledPixmaps->isChecked() );
  // KomposeSettings::instance()->setDynamicVirtDeskLayout( dynamicVirtDeskLayout->isChecked() );
  KomposeSettings::instance()->setImageEffects( imageEffects->isChecked() );
  KomposeSettings::instance()->setBlurBackground( blurBackground->isChecked() );
  KomposeSettings::instance()->setShowDesktopNum( showDesktopNum->isChecked() );

  KomposeSettings::instance()->setShowWindowTitles( showWindowTitles->isChecked() );
  KomposeSettings::instance()->setWindowTitleFont( *windowTitleFont );
  KomposeSettings::instance()->setWindowTitleFontColor( windowTitleFontColor->color() );
  KomposeSettings::instance()->setWindowTitleFontShadowColor( windowTitleFontShadowColor->color() );
  KomposeSettings::instance()->setShowWindowTitleShadow( showWindowTitleShadow->isChecked() );

  KomposeSettings::instance()->setWindowBorderActiveColor( windowBorderActiveColor->color() );
  KomposeSettings::instance()->setWindowBorderInactiveColor( windowBorderInactiveColor->color() );
  KomposeSettings::instance()->setWindowBorderActiveWidth( windowBorderActiveWidth->value() );
  KomposeSettings::instance()->setWindowBorderInactiveWidth( windowBorderInactiveWidth->value() );
  KomposeSettings::instance()->setWindowBorderActiveStyle( windowBorderActiveStyle->currentItem() );
  KomposeSettings::instance()->setWindowBorderInactiveStyle( windowBorderInactiveStyle->currentItem() );

  KomposeSettings::instance()->setDesktopTitleFont( *desktopTitleFont );
  KomposeSettings::instance()->setDesktopTitleFontColor( desktopTitleFontColor->color() );
  KomposeSettings::instance()->setDesktopTitleFontHighlightColor( desktopTitleFontHighlightColor->color() );

  KomposeSettings::instance()->setShowIcons( showIcons->isChecked() );
  KomposeSettings::instance()->setIconSize( iconSize->value() );

  KomposeSettings::instance()->setActivateOnTopLeftCorner( m_topLeftCorner->isChecked() );
  KomposeSettings::instance()->setActivateOnTopRighCorner( m_topRightCorner->isChecked() );
  KomposeSettings::instance()->setActivateOnBottomLeftCorner( m_bottomLeftCorner->isChecked() );
  KomposeSettings::instance()->setActivateOnBottomRightCorner( m_bottomRightCorner->isChecked() );

  KomposeSettings::instance()->setActivateOnTopEdge( m_topEdge->isChecked() );
  KomposeSettings::instance()->setActivateOnRightEdge( m_rightEdge->isChecked() );
  KomposeSettings::instance()->setActivateOnBottomEdge( m_bottomEdge->isChecked() );
  KomposeSettings::instance()->setActivateOnLeftEdge( m_leftEdge->isChecked() );
  KomposeSettings::instance()->setAutoLockDelay( autoLockDelay->value() );

  if (m_hasXinerama)
  {
    int viewScreen = m_viewScreen->value();
    if ( m_viewScreenAll->isChecked() )
      viewScreen = -1;
    KomposeSettings::instance()->setViewScreen( viewScreen );
  }

  KomposeSettings::instance()->writeConfig();

  KDialogBase::slotApply();
}

void KomposePreferences::slotOk()
{
  slotApply();
  KDialogBase::slotOk();
}

void KomposePreferences::setUseCompositeToggled( bool )
{}

#include "komposepreferences.moc"
