#ifndef __KDIALOGD_H__
#define __KDIALOGD_H__

#include <tdefile.h>
#include <tdefiledialog.h>
#include <tdefiledialog.h>
#include <kdirselectdialog.h>
#include "common.h"
#include "config.h"

#ifdef KDIALOGD_APP
class TQTimer;
#else
#include <kdedmodule.h>
#endif
class KDialogBase;
class TDEConfig;

class KDialogDFileDialog : public KFileDialog
{
    TQ_OBJECT
  

    public:

    KDialogDFileDialog(TQString &an, Operation op, const TQString& startDir, const TQString& filter,
                       bool confirmOw);
    virtual ~KDialogDFileDialog();

    public slots:

    void accept();
    void slotOk();

    signals:

    void ok(const TQStringList &items);

    private:

    bool    itsConfirmOw;
    TQString &itsAppName;
};

class KDialogDDirSelectDialog : public KDirSelectDialog
{
    TQ_OBJECT
  

    public:

    KDialogDDirSelectDialog(TQString &an, const TQString &startDir = TQString(),
                            bool localOnly = false,
                            TQWidget *parent = 0L,
                            const char *name = 0, bool modal = false);
    virtual ~KDialogDDirSelectDialog();

    public slots:

    void slotOk();

    signals:

    void ok(const TQStringList &items);

    private:

    TQString &itsAppName;
};

class KDialogDClient : public TQObject
{
    TQ_OBJECT
  

    public:

    KDialogDClient(int sock, const TQString &an, TQObject *parent);
    virtual ~KDialogDClient();

    public slots:

    void read();
    void close();
    void ok(const TQStringList &items);
    void finished();

    signals:

    void error(KDialogDClient *);

    private:

    void cancel();
    bool readData(TQCString &buffer, int size);
    bool readData(char *buffer, int size)        { return readBlock(itsFd, buffer, size); }
    bool writeData(const char *buffer, int size) { return writeBlock(itsFd, buffer, size); }
    bool readString(TQString &str);
    bool writeString(const TQString &str);
    void initDialog(const TQString &caption, KDialogBase *d, unsigned int xid);

    private:

    int          itsFd;
    KDialogBase  *itsDlg;
    bool         itsAccepted;
    TQString      itsAppName;
};

class KDialogD : public TQObject
{
    TQ_OBJECT
  

    public:

    KDialogD(TQObject *parent=0L);
    virtual ~KDialogD();

    public slots:

    void newConnection();
    void deleteConnection(KDialogDClient *client);
    void timeout();

    static TDEConfig * config() { return theirConfig; }

    private:

#ifdef KDIALOGD_APP
    TQTimer *itsTimer;
    int    itsTimeoutVal;
#endif
    int    itsFd,
           itsNumConnections;

    static TDEConfig *theirConfig;
};

#ifndef KDIALOGD_APP
class KDialogDKDED : public KDEDModule
{
    public:

    KDialogDKDED(const TQCString &obj);
};
#endif

#endif
