/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tdeapplication.h>
#include <kservice.h>
#include <kservicegroup.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <tqdir.h>
#include <tqfileinfo.h>
#include <kbfxplasmadataplugin-common.h>
#include <kstandarddirs.h>

KbfxDataStack *
view ()
{

	KbfxDataGroup *appGroup = new KbfxDataGroup ();
	KbfxDataGroupList *glist = new KbfxDataGroupList ();
	KbfxDataStack *gstack = new KbfxDataStack ();


	glist->setName ( "List" );
	glist->setIcon ( "newstuff" );
	appGroup->setName ( "RecentStuff" );

	TQString path =
	    TDEStandardDirs ().localtdedir () + "/share/apps/RecentDocuments/";



	TQDir d ( path );
	d.setFilter ( TQDir::Files | TQDir::Hidden | TQDir::NoSymLinks );
	d.setSorting ( TQDir::Size | TQDir::Reversed );
	d.setNameFilter ( "*.desktop" );

	const TQFileInfoList *list = d.entryInfoList ();
	TQFileInfoListIterator it ( *list );
	TQFileInfo *fi;

	while ( ( fi = it.current () ) != 0 )
	{

		KDesktopFile *desktop = new KDesktopFile ( fi->filePath () );

		KbfxDataSource *src = new KbfxDataSource ();

		src->setName ( desktop->readName () );
		src->setContentPath ( fi->filePath () );
		src->setIconPath ( desktop->readIcon () );
		src->setCommand ( "kfmclient exec " + desktop->readEntry ( "URL" ) );

		appGroup->addItem ( src );

		delete desktop;
		++it;
	}


	gstack->setName ( "RecentStuff" );

	glist->addGroup ( appGroup );
	gstack->addGroupList ( glist );
	return gstack;


}

TQString
name ()
{
	return TQString ( "RecentStuff" );
}

TQString
type ()
{
	return TQString ( "Stub Type" );
}


uint
id ()
{
	return 1;			//TODO see what can be done... manybe rand()?
}


#include <ktrader.h>

KbfxDataGroup *
search ( TQString _keyword )
{
	KbfxDataGroup *appGroup = new KbfxDataGroup ();
//	KbfxDataGroupList *glist = new KbfxDataGroupList ();
//	KbfxDataStack *gstack = new KbfxDataStack ();



	TQString path =
	    TDEStandardDirs ().localtdedir () + "/share/apps/RecentDocuments/";

	TQDir d ( path );
	d.setFilter ( TQDir::Files | TQDir::Hidden | TQDir::NoSymLinks );
	d.setSorting ( TQDir::Size | TQDir::Reversed );
	d.setNameFilter ( "*.desktop" );

	const TQFileInfoList *list = d.entryInfoList ();
	TQFileInfoListIterator it ( *list );
	TQFileInfo *fi;

	while ( ( fi = it.current () ) != 0 )
	{
		if ( fi->fileName ().contains ( _keyword ) > 0 )
		{
			KDesktopFile *desktop = new KDesktopFile ( fi->filePath () );

			KbfxDataSource *src = new KbfxDataSource ();

			src->setName ( desktop->readName () );
			src->setContentPath ( fi->filePath () );
			src->setIconPath ( desktop->readIcon () );
			src->setCommand ( "kfmclient exec " + desktop->readEntry ( "URL" ) );
			appGroup->addItem ( src );
			delete desktop;
		}

		++it;
	}

	return appGroup;
}
