/* This file is part of the KDE project
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXI_CSVWIDGETS_H
#define KEXI_CSVWIDGETS_H

#include <tqvaluevector.h>
#include <kcombobox.h>

class KLineEdit;
class KActiveLabel;
class TQLabel;

#define KEXICSV_DEFAULT_FILE_TEXT_QUOTE "\""
#define KEXICSV_DEFAULT_CLIPBOARD_TEXT_QUOTE ""
#define KEXICSV_DEFAULT_FILE_DELIMITER ","
#define KEXICSV_DEFAULT_CLIPBOARD_DELIMITER "\t"
#define KEXICSV_DEFAULT_FILE_DELIMITER_INDEX 0

//! \return a list of mimetypes usable for handling CSV format handling
TQStringList csvMimeTypes();

/*! @short A helper widget showing a short text information with an icon.
 See ctor for details.
 Used by CSV import and export dialogs. */
class KexiCSVInfoLabel : public TQWidget
{
	public:
		/* Sets up a new info label \a labelText label with text like "Preview of data from file:".
		 setFileName() can be used to display filename and setCommentAfterFileName() to display 
		 additional comment.

		 The widget's layout can look like this:

		 \pre [icon] [labeltext] [filename] [comment]
		*/
		KexiCSVInfoLabel( const TQString& labelText, TQWidget* parent );

		void setFileName( const TQString& fileName );
		void setLabelText( const TQString& text );
		void setCommentText( const TQString& text );
//		void setIconForFileName();

		//! sets icon pixmap to \a iconName. Used wher setIconForFilename was false in ctor.
		void setIcon(const TQString& iconName);

		TQLabel* leftLabel() const { return m_leftLabel; }
		KActiveLabel* fileNameLabel() const { return m_fnameLbl; }
		KActiveLabel* commentLabel() const { return m_commentLbl; }
		TQFrame* separator() const { return m_separator; }

	protected:
		TQLabel *m_leftLabel, *m_iconLbl;
		KActiveLabel *m_fnameLbl, *m_commentLbl;
		TQFrame* m_separator;
};

//! @short A combo box widget providing a list of possible delimiters
//! Used by CSV import and export dialogs
class KexiCSVDelimiterWidget : public TQWidget
{
	TQ_OBJECT
  

	public:
		KexiCSVDelimiterWidget( bool lineEditOnBottom, TQWidget * parent = 0 );

		TQString delimiter() const { return m_delimiter; }
		void setDelimiter(const TQString& delimiter);

	signals:
		void delimiterChanged(const TQString& delimiter);

	protected slots:
		//! only called when a delimiter was set by user directly
		void slotDelimiterChanged(int idx);
		void slotDelimiterChangedInternal(int idx);
		void slotDelimiterLineEditTextChanged( const TQString & );
		void slotDelimiterLineEditReturnPressed();

	protected:
		TQString m_delimiter;
		TQValueVector<TQString> m_availableDelimiters;
		KComboBox* m_combo;
		KLineEdit* m_delimiterEdit;
};

//! @short A combo box widget providing a list of possible quote characters
//! Used by CSV import and export dialogs
class KexiCSVTextQuoteComboBox : public KComboBox
{
	public:
		KexiCSVTextQuoteComboBox( TQWidget * parent = 0 );

		TQString textQuote() const;

		//! Sets text quote. Only available are: ", ', and empty string.
		void setTextQuote(const TQString& textQuote);
};

#endif
