/*
 *  kis_tool_fill.h - part of Krayon^Chalk
 *
 *  Copyright (c) 2004 Bart Coppens <kde@bartcoppens.be>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __filltool_h__
#define __filltool_h__

#include <tqpoint.h>

#include "kis_point.h"
#include "kis_tool_paint.h"

class KisPainter;
class TQWidget;
class TQLabel;
class TQCheckBox;
class KIntNumInput;
class TDEActionCollection;

class KisToolFill : public KisToolPaint {

    typedef KisToolPaint super;
    TQ_OBJECT
  

public:

    KisToolFill();
    virtual ~KisToolFill();

    virtual void setup(TDEActionCollection *collection);
    virtual enumToolType toolType() { return TOOL_FILL; }
    virtual TQ_UINT32 priority() { return 0; }

    virtual void update(KisCanvasSubject *subject);

    virtual void buttonPress(KisButtonPressEvent*);
    virtual void buttonRelease(KisButtonReleaseEvent*);

    bool flood(int startX, int startY);

    virtual TQWidget* createOptionWidget(TQWidget* parent);

public slots:
    virtual void slotSetThreshold(int);
    virtual void slotSetUsePattern(bool);
    virtual void slotSetSampleMerged(bool);
    virtual void slotSetFillSelection(bool);

private:
    KisPoint m_startPos;
    int m_threshold;
    TQ_INT32 m_depth;
    KisLayerSP m_lay;
    TQ_UINT8* m_oldColor, *m_color;
    KisPainter *m_painter;
    KisCanvasSubject *m_subject;
    KisImageSP m_currentImage;
    bool *m_map, m_unmerged, m_usePattern, m_fillOnlySelection;
    KisSelectionSP m_selection;

    TQLabel *m_lbThreshold;
    KIntNumInput *m_slThreshold;
    TQCheckBox *m_checkUsePattern;
    TQCheckBox *m_checkSampleMerged;
    TQCheckBox *m_checkFillSelection;
    bool m_wasPressed; // use for preventing bug:133148
};


#include "kis_tool_factory.h"

class KisToolFillFactory : public KisToolFactory {
    typedef KisToolFactory super;
public:
    KisToolFillFactory() : super() {};
    virtual ~KisToolFillFactory(){};

    virtual KisTool * createTool(TDEActionCollection * ac) {
        KisToolFill * t = new KisToolFill();
        TQ_CHECK_PTR(t);
        t->setup(ac);
        return t;
    }
    virtual KisID id() { return KisID("fill", i18n("Fill Tool")); }

};




#endif //__filltool_h__

