
# setup.py file for desktop-effects-tde
# by the Kubuntu Team, inspired by the Restricted Manager setup file
# -*- coding: utf-8 -*-
from distutils.core import setup, Extension
from distutils.command.clean import clean
from distutils.dir_util import remove_tree
import subprocess, glob, os.path, shutil

# for kcm modules building
import kdedistutils

mo_files = []
# HACK: make sure that the mo files are generated and up-to-date
#subprocess.call(["make", "-C", "po", "build-mo"])
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    mo_files.append((targetpath, [filepath]))

# build .py files from the .ui files.
for file in glob.glob("data/*.ui"):
    subprocess.call(["kdepyuic", file])
    shutil.move(file[5:-3]+".py","./")
# patch desktopeffectsdialog.py for kcm-specific fixes
subprocess.call(["patch", "-p1", "-i" "data/kcm-fix.patch"])

class RMClean(clean):
    ''' cleans up the hacks above, mostly '''
    def run(self):
        clean.run(self)
        if os.path.exists('build/'):
            remove_tree('build/')
        generated_files = ['applications/kde/kcm_restricted-manager.cpp' , 'RestrictedManager/ManagerWindowKDE.py',
                        'RestrictedManager/FwHandlerBcm.py', 'RestrictedManager/FwHandlerProgress.py']
        for file in generated_files:
            if os.path.exists(file):
                os.remove(file)

kdedistutils.setup(
    name="desktop-effects-tde",
    author="Martin Böhm",
    author_email="martin.bohm@kubuntu.org",
    maintainer="Kubuntu Team",
    maintainer_email="kubuntu-devel@lists.ubuntu.com",
    url="http://www.kubuntu.org",
    license="gpl",
    description="enable and configure Compiz effects in TDE",
    packages=["DesktopEffects/"],
    data_files=[("share/desktop-effects", glob.glob("data/*.png")),
                ("share/applications/tde", glob.glob("applications/tde/*.desktop"))
               ],
    scripts=["desktop-effects-tde"],
    kcontrol_modules = [ ('applications/kde/desktop-effects-tde.desktop.in', 'DesktopEffectsTDE')],
    cmdclass = { 'clean' : RMClean }
)
