###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for OpenSSL

find_package( OpenSSL )

if( NOT OPENSSL_FOUND )
    check_include_file( openssl/err.h HAVE_OPENSSL_H )
    check_library_exists( ssl OPENSSL_init_ssl "" HAVE_LIBSSL_11 )
    check_library_exists( crypto EVP_EncryptInit_ex "" HAVE_LIBCRYPTO )

    if( NOT HAVE_LIBSSL_11 )
        check_library_exists( ssl SSL_library_init "" HAVE_LIBSSL )
    endif()

    if( HAVE_OPENSSL_H AND HAVE_LIBCRYPTO AND (HAVE_LIBSSL_11 OR HAVE_LIBSSL)  )
        set( SSL_FOUND 1 CACHE INTERNAL "" FORCE )
        find_file( OPENSSLV_H openssl/opensslv.h )
        file( STRINGS "${OPENSSLV_H}" SSL_VERSION REGEX "#[ \t]*define[ \t]*OPENSSL_VERSION_TEXT" )
        string( REGEX REPLACE "# *define[ \t]*OPENSSL_VERSION_TEXT[ \t]*\"[^0-9 ]* *([^ ]*).*" "\\1" SSL_VERSION "${SSL_VERSION}" )
        set( SSL_VERSION "${SSL_VERSION}" CACHE INTERNAL "" FORCE )
        message( STATUS "Found OpenSSL: version ${SSL_VERSION}" )
        set( OPENSSL_LIBRARIES "ssl;crypto" CACHE INTERNAL "ssl and crypto libs" FORCE )
    endif()
endif( NOT OPENSSL_FOUND )

if( NOT OPENSSL_FOUND )
    tde_message_fatal( "OpenSSL support is required but OpenSSL was not found on your system" )
 else()
    check_include_file( "openssl/aes.h"      HAVE_OPENSSL_AES_H )
    check_include_file( "openssl/blowfish.h" HAVE_OPENSSL_BLOWFISH_H )
endif( NOT OPENSSL_FOUND )


##### check for zlib

find_package( ZLIB )

if( ZLIB_FOUND )
    set( HAVE_LIBZ 1 )
endif( ZLIB_FOUND )


##### check for functions

check_function_exists( poll   HAVE_POLL )
check_function_exists( select HAVE_SELECT )


##### check headers

check_include_file(  "sys/time.h"        HAVE_SYS_TIME_H )
check_include_files( "sys/time.h;time.h" TIME_WITH_SYS_TIME )
check_include_files( "sys/poll.h"        HAVE_SYS_POLL_H )


##### check for symbols

check_symbol_exists( gethostbyname "netdb.h" HAVE_GETHOSTBYNAME )
check_symbol_exists( gethostbyaddr "netdb.h" HAVE_GETHOSTBYADDR )
