###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

set( ENV{PKG_CONFIG_PATH} "${PKG_CONFIG_PATH}:$ENV{PKG_CONFIG_PATH}:${LIB_INSTALL_DIR}/pkgconfig" )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for pthread

find_package ( Threads REQUIRED )


##### check for OpenGL

pkg_search_module( GL gl )
if( NOT GL_FOUND )
  tde_message_fatal( "opengl is required but was not found on your system" )
endif( )


##### check for libkexif

if( WITH_KEXIF )
  pkg_search_module( KEXIF libkexif )
  if( NOT KEXIF_FOUND )
    tde_message_fatal( "libkexif was requested but not found on your system" )
  endif( )
  set ( SQ_HAVE_KEXIF 1 )
endif()


##### check for libkipi

if( WITH_KIPI )
  pkg_search_module( KIPI libkipi )
  if( NOT KIPI_FOUND )
    tde_message_fatal( "libkipi was requested but not found on your system" )
  endif( )
  set ( SQ_HAVE_KIPI 1 )
endif()


##### check for libksquirrel

pkg_search_module( KSQUIRREL ksquirrellibs )
if( NOT KSQUIRREL_FOUND )
  tde_message_fatal( "libksquirrel is required but not found on your system" )
endif( )


##### check specific architecture dependant support
if( CMAKE_SYSTEM_PROCESSOR MATCHES "i.86" )

  # MMX support
  cmake_host_system_information(RESULT HAVE_X86_MMX QUERY HAS_MMX)
  if(HAVE_X86_MMX)
    set(CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS} -DHAVE_X86_MMX")
  endif(HAVE_X86_MMX)

endif( )


##### check for required include files

check_include_file( "kregexpeditorinterface.h" SQ_HAVE_KREGEXP )
check_include_file( "utime.h" HAVE_UTIME_H )
