/***************************************************************************
* $Id$
**
* Definition of something or other
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;


class Rot13 extends TQWidget {
private    TQMultiLineEdit  left,  right;



Rot13()
{
    left = new TQMultiLineEdit( this, "left" );
    right = new TQMultiLineEdit( this, "right" );
    connect( left, TQ_SIGNAL("textChanged()"), this, TQ_SLOT("changeRight()") );
    connect( right, TQ_SIGNAL("textChanged()"), this, TQ_SLOT("changeLeft()") );

    TQPushButton  quit = new TQPushButton( "&Quit", this );
    quit.setFocusPolicy( NoFocus );
    connect( quit, TQ_SIGNAL("clicked()"), tqApp(), TQ_SLOT("quit()") );

    TQGridLayout  l = new TQGridLayout( this, 2, 2, 5 );
    l.addWidget( left, 0, 0 );
    l.addWidget( right, 0, 1 );
    l.addWidget( quit, 1, 1, AlignRight );

    left.setFocus();
}


void changeLeft()
{
    left.blockSignals( true );
    left.setText( rot13( right.text() ) );
    left.blockSignals( false );
}


void changeRight()
{
    right.blockSignals( true );
    right.setText( rot13( left.text() ) );
    right.blockSignals( false );
}


String rot13( String  input )
{
    char[] r = input.toCharArray();
    int i = r.length;
    while( i-- != 0 ) {
	if ( r[i] >= (int) 'A' && r[i] <= (int) 'M' ||
	     r[i] >= (int) 'a' && r[i] <= (int) 'm' )
	    r[i] = (char) (r[i] + 13);
	else if  ( r[i] >= (int) 'N' && r[i] <= (int) 'Z' ||
		   r[i] >= (int) 'n' && r[i] <= (int) 'z' )
	    r[i] = (char) (r[i] - 13);
    }
    return new String(r);
}


public static void main(String[] args)
{
    TQApplication a = new TQApplication( args );
    Rot13 r = new Rot13();
    r.resize( 400, 400 );
    a.setMainWidget( r );
    r.setCaption("Qt Example - ROT13");
    r.show();
    a.exec();
    return;
}

	static {
		qtjava.initialize();
	}
}
