/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <tqvariant.h>

#include "orderindicator.h"
#include "formwindow.h"

#include <tqpainter.h>
#include <tqbitmap.h>
#include <tqapplication.h>

OrderIndicator::OrderIndicator( int i, TQWidget* w, FormWindow *fw )
    : TQWidget( fw, "order_indicator", WMouseNoMask ), formWindow( fw )
{
    order = -1;
    widget = w;
    setBackgroundMode( NoBackground );
    setAutoMask( true );
    setOrder( i, w );
}


OrderIndicator::~OrderIndicator()
{
}


void OrderIndicator::setOrder( int i, TQWidget* wid )
{
    if ( widget != wid )
	return;
    if ( !wid->isVisibleTo( formWindow ) ) {
	hide();
	return;
    }

    if ( order == i ) {
	show();
	raise();
	return;
    }
    order = i;
    int w = fontMetrics().width( TQString::number( i ) ) + 10;
    int h = fontMetrics().lineSpacing() * 3 / 2;
    TQFont f( font() );
    f.setBold( true );
    setFont( f );
    resize( TQMAX( w, h ), h );
    update(); // in case the size didn't change
    reposition();
    show();
    raise();
}

void OrderIndicator::reposition()
{
    TQPoint p =parentWidget()->mapFromGlobal( widget->mapToGlobal( widget->rect().topLeft() ) );
    move( p - TQPoint( width()/3, height()/3 ) );
}


void OrderIndicator::paintEvent( TQPaintEvent * )
{
    TQPainter p( this );
    p.setPen( white );
    p.setBrush( blue );
    p.drawEllipse( rect() );
    p.drawText( rect(), AlignCenter, TQString::number( order ) );
}


void OrderIndicator::updateMask()
{
    TQBitmap bm( size() );
    bm.fill( color0 );
    {
	TQPainter p( &bm, this );
	p.setPen( color1 );
	p.setBrush( color1 );
	p.drawEllipse( rect() );
    }
    setMask( bm );
}

void OrderIndicator::mousePressEvent( TQMouseEvent *e )
{
    TQApplication::sendEvent( widget, e );
}
#include "orderindicator.moc"
