/***************************************************************************
                        specialinformation.h - internal commands information
                             -------------------
    copyright            : (C) 2004 by Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
  
#ifndef _HAVE_SPECIALINFORMATION_H_
#define _HAVE_SPECIALINFORMATION_H_

/* QT INCLUDES */
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqmap.h>
#include <tqpair.h>

class SpecialFunction
{
public:
 
   /* flags for getting function prototype:
      SkipFirstArgument - ignore first argument (useful for Kommander functions
         prefixed by widget name 
      ShowArgumentNames - show parameter names, not only types 
   */
   enum PrototypeFlags {SkipFirstArgument = 1, ShowArgumentNames = 2, NoSpaces = 4};
   /* Flags describing which parser supports the function */
   enum ParserType {MacroParser = 1, InternalParser = 2, AllParsers = 3};
   SpecialFunction(const TQString& function, const TQString& description
     = TQString(), int minArgs = -1, int maxArgs = -1);
   SpecialFunction(ParserType p, const TQString& function, const TQString& description
     = TQString(), int minArgs = -1, int maxArgs = -1);
   SpecialFunction()   {m_minArgs = m_maxArgs = 0;}
   /* minimum number of arguments */
   int minArg() const    {return m_minArgs;}
   /* maximum number of arguments */
   int maxArg() const    {return m_maxArgs;}
   /* checks number of arguments */
   bool isValidArg(int args) const    {return args >= minArg() && args <= maxArg();}
   /* function description */
   TQString description() const {return m_description;}
   /* function name */
   TQString name() const {return m_function;}
   /* function prototype: with parameter types and optional names */
   TQString prototype(uint prototypeFlags = 0) const;
   /* i-th parameter name */
   TQString argumentName(uint i) const;
   /* i-th parameter type */
   TQString argumentType(uint i) const;
   /* number of named arguments */
   int argumentCount() const;
   /* check whether given parser supports the function */
   bool isSupported(ParserType p) const;
protected:
   TQString m_function;
   TQString m_description;
   int m_minArgs, m_maxArgs;
   TQStringList m_args;
   TQStringList m_types;
   unsigned m_parserTypes;
};




class SpecialInformation
{
public:
  SpecialInformation()  {m_defaultGroup = -1;}
  static int function(int group, const TQString& fname);
  static SpecialFunction functionObject(const TQString& gname, const TQString& fname);
  static int group(const TQString& gname);
  static bool isValid(int gname, int fname);
  static bool isValid(const TQString& gname, const TQString& fname);
  static bool isValid(int gname, int fname, SpecialFunction::ParserType p);
  static bool isValid(const TQString& gname, const TQString& fname, SpecialFunction::ParserType p);
  static int minArg(int gname, int fname);
  static int maxArg(int gname, int fname);
  static int argCount(int gname, int fname);
  static bool isValidArg(int gname, int fname, int args);
  static TQString description(int gname, int fname);
  static TQString prototype(int gname, int fname, uint prototypeFlags = 0);
  /* Insert function supported by all parsers */
  static bool insert(int id, const TQString& function, const TQString description = TQString(),
    int minArgs = -1, int maxArgs = -1, SpecialFunction::ParserType = SpecialFunction::AllParsers);
  /* Insert function supported by (old) macro parser */
  static bool insertMacro(int id, const TQString& function, const TQString description = TQString(),
    int minArgs = -1, int maxArgs = -1);
  /* Insert function supported by (new) internal parser */
  static bool insertInternal(int id, const TQString& function, const TQString description = TQString(),
    int minArgs = -1, int maxArgs = -1);
  static bool insertAlias(int id, const TQString& alias);
  static void insertGroup(int id, const TQString& name, const TQString& parserName);
  static void setDefaultGroup(int gname);
  static void registerSpecials();
  static TQString parserGroupName(const TQString&);
  static TQStringList groups();
  static TQStringList functions(const TQString& group);
protected:
  static TQMap<int, TQMap<int, SpecialFunction> > m_specials;
  static TQMap<TQString, int> m_groups;
  static TQMap<TQString, TQString> m_parserGroups;
  static TQMap<int, TQMap<TQString, int> > m_functions;
  static TQMap<int, TQMap<TQString, int> > m_aliases;
  static int m_defaultGroup;
};


#endif

