/***************************************************************************
 *   Copyright (C) 2002 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _TOOLSCONFIGWIDGET_H_
#define _TOOLSCONFIGWIDGET_H_

#include "toolsconfigwidgetbase.h"
#include "tools_part.h"
#include <tqdict.h>


struct ToolsConfigEntry;


class ToolsConfigWidget : public ToolsConfigWidgetBase
{
    TQ_OBJECT
  
    
public:
    ToolsConfigWidget(TQWidget *parent=0, const char *name=0);
    ~ToolsConfigWidget();

public slots:
    void accept();

private:
    virtual void toolsmenuaddClicked();
    virtual void toolsmenuremoveClicked();
    virtual void filecontextaddClicked();
    virtual void filecontextremoveClicked();
    virtual void dircontextaddClicked();
    virtual void dircontextremoveClicked();

    virtual bool eventFilter(TQObject *o, TQEvent *e);

    void readGroup(const TQString &group, TQDict<ToolsConfigEntry> *entryDict);
    void storeGroup(const TQString &group, const TQDict<ToolsConfigEntry> &entryDict);
    void fillListBox(TQListBox *lb, const TQDict<ToolsConfigEntry> &entryDict);
    bool addEntry(ToolsConfigEntry *entry, TQDict<ToolsConfigEntry> *entryDict);

    void readConfig();
    void storeConfig();
    void updateListBoxes();
    
    TQDict<ToolsConfigEntry> m_toolsmenuEntries;
    TQDict<ToolsConfigEntry> m_filecontextEntries;
    TQDict<ToolsConfigEntry> m_dircontextEntries;
    
    ToolsPart *m_part;
};

#endif
