//-----------------------------------------------------------------------------
//
// Screen savers for TDE
//
// Copyright (c)  Martin R. Jones 1999
//

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include <tqcolor.h>

#include <tdelocale.h>
#include <tdeconfig.h>
#include <tdestandarddirs.h>
#include <kdebug.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdecrash.h>

#include "demowin.h"
#include "saver.h"

static const char appName[] = "klock";
static const char description[] = I18N_NOOP("TDE Screen Lock/Saver");
static const char version[] = "2.0.0";

static const TDECmdLineOptions options[] =
{
  { "setup", I18N_NOOP("Setup screen saver"), 0 },
  { "window-id wid", I18N_NOOP("Run in the specified XWindow"), 0 },
  { "root", I18N_NOOP("Run in the root XWindow"), 0 },
  { "demo", I18N_NOOP("Start screen saver in demo mode"), "default"},
  TDECmdLineLastOption
};

static void crashHandler( int /*sig*/ )
{
#ifdef SIGABRT
    signal ( SIGABRT, SIG_DFL );
#endif
    abort();
}

//----------------------------------------------------------------------------

int main(int argc, char *argv[])
{
    TDECmdLineArgs::init(argc, argv, appName, I18N_NOOP("TDELock"), description, version);

    TDECmdLineArgs::addCmdLineOptions(options);

    TDEApplication app;

    TDECrash::setCrashHandler( crashHandler );

    DemoWindow *demoWidget = 0;
    Window saveWin = 0;

    TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

    if (args->isSet("setup"))
    {
       setupScreenSaver();
       exit(0);
    }

    if (args->isSet("window-id"))
    {
        saveWin = atol(args->getOption("window-id"));
    }

    if (args->isSet("root"))
    {
        saveWin = TQApplication::desktop()->handle();
    }

    if (args->isSet("demo"))
    {
        saveWin = 0;
    }

    if (saveWin == 0)
    {
        demoWidget = new DemoWindow();
        demoWidget->setBackgroundMode(TQWidget::NoBackground);
//        demoWidget->setBackgroundColor(TQt::black);
        demoWidget->show();
        saveWin = demoWidget->winId();
        app.setMainWidget(demoWidget);
        app.processEvents();
    }

    startScreenSaver(saveWin);
    app.exec();
    stopScreenSaver();

    if (demoWidget)
    {
        delete demoWidget;
    }

    return 0;
}

