//=============================================================================
//
//   File : kvi_tal_listbox.cpp
//   Creation date : Mon Jan 22 2007 11:25:08 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVILIB__
#include "kvi_tal_listbox.h"

	#include <tqpainter.h>
	#include <tqstyle.h>
	#include <tqapplication.h>


	KviTalListBox::KviTalListBox(TQWidget * pParent,TQt::WFlags f)
	: TQListBox(pParent,0,f)
	{
		connect(this,TQ_SIGNAL(highlighted(TQListBoxItem *)),this,TQ_SLOT(redirect_highlighted(TQListBoxItem *)));
		connect(this,TQ_SIGNAL(selected(TQListBoxItem *)),this,TQ_SLOT(redirect_selected(TQListBoxItem *)));
		connect(this,TQ_SIGNAL(selectionChanged(TQListBoxItem *)),this,TQ_SLOT(redirect_selectionChanged(TQListBoxItem *)));
		connect(this,TQ_SIGNAL(currentChanged(TQListBoxItem *)),this,TQ_SLOT(redirect_currentChanged(TQListBoxItem *)));
		connect(this,TQ_SIGNAL(clicked(TQListBoxItem *)),this,TQ_SLOT(redirect_clicked(TQListBoxItem *)));
		connect(this,TQ_SIGNAL(clicked(TQListBoxItem *,const TQPoint &)),this,TQ_SLOT(redirect_clicked(TQListBoxItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(pressed(TQListBoxItem *)),this,TQ_SLOT(redirect_pressed(TQListBoxItem *)));
		connect(this,TQ_SIGNAL(pressed(TQListBoxItem *,const TQPoint &)),this,TQ_SLOT(redirect_pressed(TQListBoxItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(doubleClicked(TQListBoxItem *)),this,TQ_SLOT(redirect_doubleClicked(TQListBoxItem *)));
		connect(this,TQ_SIGNAL(returnPressed(TQListBoxItem *)),this,TQ_SLOT(redirect_returnPressed(TQListBoxItem *)));
		connect(this,TQ_SIGNAL(rightButtonClicked(TQListBoxItem *, const TQPoint &)),this,TQ_SLOT(redirect_rightButtonClicked(TQListBoxItem *, const TQPoint &)));
		connect(this,TQ_SIGNAL(rightButtonPressed(TQListBoxItem *, const TQPoint &)),this,TQ_SLOT(redirect_rightButtonPressed(TQListBoxItem *, const TQPoint &)));
		connect(this,TQ_SIGNAL(mouseButtonPressed(int,TQListBoxItem *,const TQPoint &)),this,TQ_SLOT(redirect_mouseButtonPressed(int,TQListBoxItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(mouseButtonClicked(int,TQListBoxItem *,const TQPoint &)),this,TQ_SLOT(redirect_mouseButtonClicked(int,TQListBoxItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(contextMenuRequested(TQListBoxItem *,const TQPoint &)),this,TQ_SLOT(redirect_contextMenuRequested(TQListBoxItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(onItem(TQListBoxItem *)),this,TQ_SLOT(redirect_onItem(TQListBoxItem *)));
	}

	void KviTalListBox::redirect_highlighted(TQListBoxItem *item)
	{
		emit highlighted((KviTalListBoxItem *)item);
	}

	void KviTalListBox::redirect_selected(TQListBoxItem *item)
	{
		emit selected((KviTalListBoxItem *)item);
	}

	void KviTalListBox::redirect_selectionChanged(TQListBoxItem * item)
	{
		emit selectionChanged((KviTalListBoxItem *)item);
	}

	void KviTalListBox::redirect_currentChanged(TQListBoxItem * item)
	{
		emit currentChanged((KviTalListBoxItem *)item);
	}

	void KviTalListBox::redirect_clicked(TQListBoxItem * item)
	{
		emit clicked((KviTalListBoxItem *)item);
	}

	void KviTalListBox::redirect_clicked(TQListBoxItem * item,const TQPoint & pnt)
	{
		emit clicked((KviTalListBoxItem *)item,pnt);
	}

	void KviTalListBox::redirect_pressed(TQListBoxItem * item)
	{
		emit pressed((KviTalListBoxItem *)item);
	}

	void KviTalListBox::redirect_pressed(TQListBoxItem * item,const TQPoint & pnt)
	{
		emit pressed((KviTalListBoxItem *)item,pnt);
	}

	void KviTalListBox::redirect_doubleClicked(TQListBoxItem * item)
	{
		emit doubleClicked((KviTalListBoxItem *)item);
	}

	void KviTalListBox::redirect_returnPressed(TQListBoxItem * item)
	{
		emit returnPressed((KviTalListBoxItem *)item);
	}

	void KviTalListBox::redirect_rightButtonClicked(TQListBoxItem * item, const TQPoint &pnt)
	{
		emit rightButtonClicked((KviTalListBoxItem *)item,pnt);
	}

	void KviTalListBox::redirect_rightButtonPressed(TQListBoxItem * item, const TQPoint &pnt)
	{
		emit rightButtonPressed((KviTalListBoxItem *)item,pnt);
	}

	void KviTalListBox::redirect_mouseButtonPressed(int button,TQListBoxItem * item,const TQPoint & pos)
	{
		emit mouseButtonPressed(button,(KviTalListBoxItem *)item,pos);
	}

	void KviTalListBox::redirect_mouseButtonClicked(int button,TQListBoxItem * item,const TQPoint & pos)
	{
		emit mouseButtonClicked(button,(KviTalListBoxItem *)item,pos);
	}

	void KviTalListBox::redirect_contextMenuRequested(TQListBoxItem * item,const TQPoint & pos)
	{
		emit contextMenuRequested((KviTalListBoxItem *)item,pos);
	}

	void KviTalListBox::redirect_onItem(TQListBoxItem * i)
	{
		emit onItem((KviTalListBoxItem *)i);
	}

	KviTalListBoxText::KviTalListBoxText( KviTalListBox *listbox, const TQString &text )
	    :KviTalListBoxItem( listbox )
	{
	    setText( text );
	}
	
	KviTalListBoxText::KviTalListBoxText( const TQString &text )
	    :KviTalListBoxItem()
	{
	    setText( text );
	}
	
	KviTalListBoxText::KviTalListBoxText( KviTalListBox* listbox, const TQString &text, KviTalListBoxItem *after )
	    : KviTalListBoxItem( listbox, after )
	{
	    setText( text );
	}
	
	KviTalListBoxText::~KviTalListBoxText()
	{
	}
	
	void KviTalListBoxText::paint( TQPainter *painter )
	{
	    int itemHeight = height( listBox() );
	    TQFontMetrics fm = painter->fontMetrics();
	    int yPos = ( ( itemHeight - fm.height() ) / 2 ) + fm.ascent();
	    painter->drawText( 3, yPos, text() );
	}
	
	int KviTalListBoxText::height( const KviTalListBox* lb ) const
	{
	    int h = lb ? lb->fontMetrics().lineSpacing() + 2 : 0;
	    return TQMAX( h, TQApplication::globalStrut().height() );
	}
	
	int KviTalListBoxText::width( const KviTalListBox* lb ) const
	{
	    int w = lb ? lb->fontMetrics().width( text() ) + 6 : 0;
	    return TQMAX( w, TQApplication::globalStrut().width() );
	}
	
	int KviTalListBoxText::RTTI = 1;
	
	int KviTalListBoxText::rtti() const
	{
	    return RTTI;
	}

	KviTalListBoxPixmap::KviTalListBoxPixmap( KviTalListBox* listbox, const TQPixmap &pixmap )
	    : KviTalListBoxItem( listbox )
	{
	    pm = pixmap;
	}
	
	KviTalListBoxPixmap::KviTalListBoxPixmap( const TQPixmap &pixmap )
	    : KviTalListBoxItem()
	{
	    pm = pixmap;
	}
	
	KviTalListBoxPixmap::KviTalListBoxPixmap( KviTalListBox* listbox, const TQPixmap &pixmap, KviTalListBoxItem *after )
	    : KviTalListBoxItem( listbox, after )
	{
	    pm = pixmap;
	}
	
	KviTalListBoxPixmap::~KviTalListBoxPixmap()
	{
	}
	
	KviTalListBoxPixmap::KviTalListBoxPixmap( KviTalListBox* listbox, const TQPixmap &pix, const TQString& text)
	    : KviTalListBoxItem( listbox )
	{
	    pm = pix;
	    setText( text );
	}

	KviTalListBoxPixmap::KviTalListBoxPixmap( const TQPixmap & pix, const TQString& text)
	    : KviTalListBoxItem()
	{
	    pm = pix;
	    setText( text );
	}
	
	KviTalListBoxPixmap::KviTalListBoxPixmap( KviTalListBox* listbox, const TQPixmap & pix, const TQString& text,
					KviTalListBoxItem *after )
	    : KviTalListBoxItem( listbox, after )
	{
	    pm = pix;
	    setText( text );
	}
	
	void KviTalListBoxPixmap::paint( TQPainter *painter )
	{
	    int itemHeight = height( listBox() );
	    int yPos;
	
	    const TQPixmap *pm = pixmap();
	    if ( pm && ! pm->isNull() ) {
		yPos = ( itemHeight - pm->height() ) / 2;
		painter->drawPixmap( 3, yPos, *pm);
	    }
	
	    if ( !text().isEmpty() ) {
		TQFontMetrics fm = painter->fontMetrics();
		yPos = ( ( itemHeight - fm.height() ) / 2 ) + fm.ascent();
		painter->drawText( pm->width() + 5, yPos, text() );
	    }
	}
	
	int KviTalListBoxPixmap::height( const KviTalListBox* lb ) const
	{
	    int h;
	    if ( text().isEmpty() )
		h = pm.height();
	    else
		h = TQMAX( pm.height(), lb->fontMetrics().lineSpacing() + 2 );
	    return TQMAX( h, TQApplication::globalStrut().height() );
	}
	
	int KviTalListBoxPixmap::width( const KviTalListBox* lb ) const
	{
	    if ( text().isEmpty() )
		return TQMAX( pm.width() + 6, TQApplication::globalStrut().width() );
	    return TQMAX( pm.width() + lb->fontMetrics().width( text() ) + 6,
		    TQApplication::globalStrut().width() );
	}
	
	int KviTalListBoxPixmap::RTTI = 2;
	
	int KviTalListBoxPixmap::rtti() const
	{
	    return RTTI;
	}
	
	#include "kvi_tal_listbox_qt3.moc"

