/***************************************************************************
 *   Copyright (C) 2005 by Mark Six                                        *
 *   marksix@xs4all.nl                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KPORTVIEW_H
#define KPORTVIEW_H

#include <tdetoolbar.h>
#include <tqcheckbox.h>
#include <klineedit.h>
#include "kport.h"
#include <tdesimpleconfig.h>

class KPortView : public TDEToolBar
{
	TQ_OBJECT
  
	public:
    	KPortView( CPicoBlaze *cpu, TQWidget *parent = 0, const char *name = 0);
	   	~KPortView();
		
		KPort	* m_port ;

	public slots:
		void read() ;
		void write( unsigned char value ) ;
		
		void writeableToggled( bool on ) ;
		void readableToggled( bool on ) ;
		
		void setID( const TQString & newID ) ;
		TQString id() ;

		void readConfig( TDESimpleConfig &config, TQString group ) ;
		void writeConfig( TDESimpleConfig &config, TQString group ) ;

	signals:
//		void closing( KPortView *ioport ) ;
		
	protected:
//		virtual void closeEvent ( TQCloseEvent * e ) ;

		TQCheckBox * m_bits[ 8 ], * m_readable, * m_writeable ;
		KLineEdit * m_editID ;
		
		CPicoBlaze * m_cpu ;

		TQColor m_backgroundColor ;
		
};

#endif
