#include <noatun/engine.h>
#include <noatun/player.h>
#include <noatun/app.h>
#include <noatun/playlist.h>

#include <tqlayout.h>

#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <tdelocale.h>
#include <tqclipboard.h>

#include "keyz.h"

extern "C"
{
    TDE_EXPORT Plugin *create_plugin()
    {
        return new Keyz();
    }
}

TDEGlobalAccel * Keyz::s_accel = 0L;

Keyz::Keyz() : TQObject( 0L, "Keyz" ), Plugin(), preMuteVol(0)
{
    NOATUNPLUGINC(Keyz);
    Player *player = napp->player();

    if ( !s_accel )
    {
        s_accel = new TDEGlobalAccel( this, "noatunglobalaccel" );
        s_accel->insert( "PlayPause", i18n("Play/Pause"), TQString(),
                         CTRL+ALT+Key_P, KKey::QtWIN+CTRL+Key_P,
                         player, TQ_SLOT( playpause() ));
        s_accel->insert( "Stop", i18n("Stop Playing"), TQString(),
                         CTRL+ALT+Key_S, KKey::QtWIN+CTRL+Key_S,
                         player, TQ_SLOT( stop() ));
        s_accel->insert( "Back", i18n("Back"), TQString(),
                         CTRL+ALT+Key_Left, KKey::QtWIN+CTRL+Key_Left,
                         player, TQ_SLOT( back() ));
        s_accel->insert( "Forward", i18n("Forward"), TQString(),
                         CTRL+ALT+Key_Right, KKey::QtWIN+CTRL+Key_Right,
                         player, TQ_SLOT( forward() ));
        s_accel->insert( "Playlist", i18n("Show/Hide Playlist"), TQString(),
                         CTRL+ALT+Key_L, KKey::QtWIN+CTRL+Key_L,
                         player, TQ_SLOT( toggleListView() ));
        s_accel->insert( "OpenFile", i18n("Open File to Play"), TQString(),
                         CTRL+ALT+Key_O, KKey::QtWIN+CTRL+Key_O,
                         napp, TQ_SLOT( fileOpen() ));
        s_accel->insert( "Effects", i18n("Effects Configuration"), TQString(),
                         CTRL+ALT+Key_E, KKey::QtWIN+CTRL+Key_E,
                         napp, TQ_SLOT( effectView() ));
        s_accel->insert( "Preferences", i18n("Preferences"), TQString(),
                         CTRL+ALT+Key_F, KKey::QtWIN+CTRL+Key_F,
                         napp, TQ_SLOT( preferences() ));
        s_accel->insert( "VolumeUp", i18n("Volume Up"), TQString(),
                         CTRL+ALT+SHIFT+Key_Up, KKey::QtWIN+CTRL+SHIFT+Key_Up,
                         this, TQ_SLOT( slotVolumeUp() ));
        s_accel->insert( "VolumeDown", i18n("Volume Down"), TQString(),
                         CTRL+ALT+SHIFT+Key_Down, KKey::QtWIN+CTRL+SHIFT+Key_Down,
                         this, TQ_SLOT( slotVolumeDown() ));
        s_accel->insert( "Mute", i18n("Mute"), TQString(),
                         CTRL+ALT+Key_M, KKey::QtWIN+CTRL+Key_M,
                         this, TQ_SLOT( slotMute() ));
        s_accel->insert( "SeekForward", i18n("Seek Forward"), TQString(),
                         CTRL+ALT+SHIFT+Key_Right, KKey::QtWIN+CTRL+SHIFT+Key_Right,
                         this, TQ_SLOT( slotForward() ));
        s_accel->insert( "SeekBackward", i18n("Seek Backward"), TQString(),
                         CTRL+ALT+SHIFT+Key_Left, KKey::QtWIN+CTRL+SHIFT+Key_Left,
                         this, TQ_SLOT( slotBackward() ));
        s_accel->insert( "NextSection", i18n("Next Section"), TQString(),
                         0, 0,
                         this, TQ_SLOT( slotNextSection() ));
        s_accel->insert( "PrevSection", i18n("Previous Section"), TQString(),
                         0, 0,
                         this, TQ_SLOT( slotPrevSection() ));
        s_accel->insert( "CopyTitle", i18n("Copy Song Title to Clipboard"), TQString(),
                         CTRL+ALT+Key_C, KKey::QtWIN+CTRL+Key_C,
                         this, TQ_SLOT( slotCopyTitle() ));

        s_accel->insert( "ToggleGUI", i18n("Show/Hide Main Window"), TQString(),
                         CTRL+ALT+Key_W, KKey::QtWIN+CTRL+Key_W,
                         napp, TQ_SLOT( toggleInterfaces() ));

        s_accel->readSettings();
        s_accel->updateConnections();
    }

    new KeyzPrefs(this);
}

Keyz::~Keyz()
{
    delete s_accel;
    s_accel = 0L;
}

void Keyz::slotVolumeUp()
{
    int vol = napp->player()->volume();
    if ( vol >= 100 )
        return;

    napp->player()->setVolume( vol + 4 );
}

void Keyz::slotVolumeDown()
{
    int vol = napp->player()->volume();
    if ( vol <= 0 )
        return;

    napp->player()->setVolume( vol - 4 );
}

void Keyz::slotForward()
{
    napp->player()->skipTo( TQMIN(napp->player()->getLength(), napp->player()->getTime() + 3000) ); // + 3 seconds
}

void Keyz::slotBackward()
{
    napp->player()->skipTo( TQMAX( 0, napp->player()->getTime() - 3000 )); // - 3 seconds
}

void Keyz::slotNextSection()
{
    Playlist *list = napp->playlist();
    if ( list ) {
        PlaylistItem item = list->nextSection();
        if ( !item.isNull() )
            napp->player()->play( item );
    }
}

void Keyz::slotPrevSection()
{
    Playlist *list = napp->playlist();
    if ( list ) {
        PlaylistItem item = list->previousSection();
        if ( !item.isNull() )
            napp->player()->play( item );
    }
}

void Keyz::slotCopyTitle()
{
    if (napp->player()->current())
        TDEApplication::kApplication()->clipboard()->setText(napp->player()->current().title());
}


void Keyz::slotMute()
{
    int vol = napp->player()->volume();

    if ( vol <= 0 ) // already muted
    {
        vol = preMuteVol;
    }
    else // we should mute
    {
        preMuteVol = vol;
        vol = 0;
    }

    napp->player()->setVolume( vol );
}

///////////////////////////////////////////////////////////////////

KeyzPrefs::KeyzPrefs( TQObject *parent ) :
    CModule( i18n("Keyz"), i18n("Shortcut Configuration"), "key_bindings",
             parent )
{
    TQVBoxLayout *layout = new TQVBoxLayout( this );
    m_chooser = new KKeyChooser( Keyz::accel(), this );
    layout->addWidget( m_chooser );
}

void KeyzPrefs::save()
{
    m_chooser->commitChanges();
    Keyz::accel()->updateConnections();
    Keyz::accel()->writeSettings();
}

#include "keyz.moc"
