
#include <tdeinstance.h>
#include <tqsplitter.h>
#include <kiconloader.h>
#include <stdlib.h>
#include "dndlistbox.h"
#include "listboxlink.h"
#include "linkview.h"
#include "baghirasidebar.h"
#include "baghirasidebar.moc"

baghiraSidebar::baghiraSidebar(TDEInstance *inst,TQObject *parent,TQWidget *widgetParent, TQString &desktopName, const char* name):
                   KonqSidebarPlugin(inst,parent,widgetParent,desktopName,name)
{
   scrollView = new LinkView(widgetParent);
   scrollView->setHScrollBarMode(TQScrollView::AlwaysOff);
   connect (scrollView->Hardware(), TQ_SIGNAL(clicked(TQListBoxItem *)), this, TQ_SLOT(callURL(TQListBoxItem *)));
   connect (scrollView->Locations(), TQ_SIGNAL(clicked(TQListBoxItem *)), this, TQ_SLOT(callURL(TQListBoxItem *)));
}

baghiraSidebar::~baghiraSidebar()
{
}

void baghiraSidebar::callURL(TQListBoxItem *item)
{
   emit openURLRequest(KURL(((ListBoxLink*)(item))->URL()), KParts::URLArgs(true,0,0));
}

void baghiraSidebar::handleURL(const KURL &url)
{
   int item = scrollView->Hardware()->currentItem();
   if ( scrollView->Hardware()->isSelected(item) && 
      KURL(((ListBoxLink*)(scrollView->Hardware()->item(item)))->URL()).url() != url.url() )
   {
      scrollView->Hardware()->setSelected(item, false);
      return;
   }
   item = scrollView->Locations()->TDEListBox::currentItem();
   if (scrollView->Locations()->isSelected(item) && 
      KURL(((ListBoxLink*)(scrollView->Locations()->item(item)))->URL()).url() != url.url() )
   {
      scrollView->Locations()->setSelected(item, false);
      return;
   }
}

extern "C" {
   TDE_EXPORT bool add_konqsidebar_baghirasidebar(TQString* fn, TQString* param, TQMap<TQString,TQString> *map) {
      Q_UNUSED(param);
      
      map->insert("Type", "Link");
      map->insert("Icon", "bab_brushed");
      map->insert("Name", "Baghira Sidebar");
      map->insert("Open", "true");
      map->insert("X-TDE-KonqSidebarModule","konqsidebar_baghirasidebar");
      fn->setLatin1("baghirasidebar%1.desktop");
      return true;
   }
}

extern "C"
{
    TDE_EXPORT void* create_konqsidebar_baghirasidebar(TDEInstance *instance,TQObject *par,TQWidget *widp,TQString &desktopname,const char *name)
    {
        return new baghiraSidebar(instance,par,widp,desktopname,name);
    }
}
