//=============================================================================
//
//   File : kvi_splash.cpp
//   Creation date : Wed Aug 8 2001 17:46:10 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVIRC__
#include "kvi_string.h"
#include "kvi_app.h"
#include "kvi_defaults.h"
#include "kvi_splash.h"
#include "kvi_locale.h"
#include "kvi_fileutils.h"
#include <tqsplashscreen.h> 


#include <tqpixmap.h>
#include <tqpainter.h>
#include <tqlayout.h>

#include <stdio.h>


KviSplashScreen::KviSplashScreen()
: TQSplashScreen(TQPixmap(1,1),TQt::WStyle_NoBorder | TQt::WType_TopLevel | TQt::WStyle_Customize | TQt::WStyle_StaysOnTop | TQt::WStyle_Splash)
{
	TQString szPix;
	TQPixmap * pix = 0;

	// check for the current theme splash screen pointer
	TQString szPointerFile;
	g_pApp->getLocalKvircDirectory(szPointerFile,KviApp::Themes,"current-splash");
	if(KviFileUtils::fileExists(szPointerFile))
	{
		TQString szBuf;
		KviFileUtils::readFile(szPointerFile,szBuf);
		if(!szBuf.isEmpty())
		{
			g_pApp->getLocalKvircDirectory(szPix,KviApp::Themes,szBuf);
			KviTQString::ensureLastCharIs(szPix,KVI_PATH_SEPARATOR_CHAR);
			szPix.append("kvi_splash.png");
			pix = new TQPixmap(szPix);
			if(pix->isNull())
			{
				// no way..
				delete pix;
				pix = 0;
			} else {
				// else we might have a themed splash screen
// 				g_pApp->getLocalKvircDirectory(szPix,KviApp::Themes,szBuf);
				KviTQString::ensureLastCharIs(szPix,KVI_PATH_SEPARATOR_CHAR);
				szPix.append("kvi_splash_overlay.png");
				m_pOverlay = new TQPixmap(szPix);
				if(m_pOverlay->isNull())
				{
					// no way..
					delete pix;
					pix = 0;
					delete m_pOverlay;
					m_pOverlay = 0;
				}
			}
		}
	}

	if(!pix)
	{
		if(g_pApp->findImage(szPix,"kvi_splash.png"))
		{
			pix = new TQPixmap(szPix);
		} else {
			// dummy image
			pix = new TQPixmap(300,200);
		}
		
		if(g_pApp->findImage(szPix,"kvi_splash_overlay.png"))
		{
			m_pOverlay = new TQPixmap(szPix);
		} else {
			m_pOverlay = new TQPixmap(300,20);
		}
	}
	
	setPixmap(*pix);
	m_pTimer = new TQTimer(this);
	connect(m_pTimer,TQ_SIGNAL(timeout()),this,TQ_SLOT(suicide()));
	delete pix;

}

// We don't need messages on the splash: they just add work to the translators and nobody can read them anyway :D
//void KviSplashScreen::message(TQString szMessage)
//{
	//TQSplashScreen::message(szMessage, TQt::AlignRight | TQt::AlignBottom, TQt::white);
//}

KviSplashScreen::~KviSplashScreen()
{
	g_pSplashScreen = 0; // make sure it's true
	delete m_pTimer;
	delete m_pOverlay;
}


void KviSplashScreen::showEvent(TQShowEvent *e)
{
	move((g_pApp->desktop()->width() - width())/2,
		(g_pApp->desktop()->height() - height())/2);
	m_creationTime = TQTime::currentTime();
}

void KviSplashScreen::hideEvent(TQHideEvent *e)
{
	suicide();
}

void KviSplashScreen::setProgress(int progress)
{
	TQPainter painter(pixmap());
	TQSize size = pixmap()->size();
	painter.drawPixmap(0,size.height() - m_pOverlay->height(),*m_pOverlay,0,0,(m_pOverlay->width() * progress) / 100,m_pOverlay->height());
	painter.end();
	//raise();
	repaint();
	g_pApp->processEvents(); //damn...
}

#define KVI_SPLASH_SCREEN_MINIMUM_TIMEOUT_IN_MSECS 2000

void KviSplashScreen::die()
{
	TQTime now = TQTime::currentTime();
	int mSecs = m_creationTime.msecsTo(now);
	int mRemaining = KVI_SPLASH_SCREEN_MINIMUM_TIMEOUT_IN_MSECS - mSecs;
	if(mRemaining < 0)mRemaining = 0;
	m_pTimer->start(mRemaining,true);
}


void KviSplashScreen::suicide()
{
	if(!g_pSplashScreen)return; // already in suicide ?
	//g_pApp->collectGarbage(this);
	g_pSplashScreen = 0;
	deleteLater();
	//delete this;
}


void KviSplashScreen::fadeTimerShot()
{
}


#include "kvi_splash.moc"
