/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _ITEM_FACTORY_H_
#define _ITEM_FACTORY_H_

#include <tqobject.h>
#include <tqlistview.h>

class LogLine;
class ParentLogLine;
class ChildLogLine;
class LogListItem;

/**
 * @author Nicolas Ternisien
 */
class ItemFactory {

	public:
		static LogListItem* createLogListItem(TQListView* view, LogLine* line);
		
		static TQString createFormattedText(LogLine* line);
		static TQString createToolTipText(LogLine* line);

		//Global useful methods
		static TQString messageFormat(TQString& message);
		static TQString labelMessageFormat(TQString label, TQString value);
	
	private:
		static LogListItem* createItem(TQListView* view, LogLine* line);
		
		static LogListItem* createParentItem(TQListView* view, ParentLogLine* line);
		
		static LogListItem* createChildItem(TQListView* view, ChildLogLine* line);
		
		static LogListItem* createBasicItem(TQListView* view, LogLine* line);
		
		static void initXorgItem(LogListItem* item);
		static void initDefaultItem(LogListItem* item);
		
		static void initItem(LogListItem* item);
		
		
		
		
		
		
		static TQString createXorgFormattedText(LogLine* line);
		static TQString createCronFormattedText(LogLine* line);
		static TQString createAcpidFormattedText(LogLine* line);
		static TQString createCupsFormattedText(LogLine* line);
		static TQString createCupsAccessFormattedText(LogLine* line);
		
		static TQString createParentFormattedText(LogLine* line);
		
		static TQString createDefaultFormattedText(LogLine* line);
		
		static TQString createApacheFormattedText(LogLine* line);
		static TQString createApacheAccessFormattedText(LogLine* line);
		static TQString createSambaFormattedText(LogLine* line);
		
		static TQString createXorgToolTipText(LogLine* line);
		
		static TQString createDefaultToolTipText(LogLine* line);

		
};

#endif
