/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
 
#include "globals.h"

#include <tdelocale.h>

#include "logLevel.h"
#include "logMode.h"

//Existing Log levels. The id value corresponds to the index in the vector
LogLevels Globals::logLevels;

LogLevel* Globals::noneLogLevel=NULL;
LogLevel* Globals::debugLogLevel=NULL;
LogLevel* Globals::informationLogLevel=NULL;
LogLevel* Globals::noticeLogLevel=NULL;
LogLevel* Globals::warningLogLevel=NULL;
LogLevel* Globals::errorLogLevel=NULL;
LogLevel* Globals::criticalLogLevel=NULL;
LogLevel* Globals::alertLogLevel=NULL;
LogLevel* Globals::emergencyLogLevel=NULL;

void Globals::setupLogLevels() {
	Globals::noneLogLevel=new LogLevel(NONE_LOG_LEVEL_ID, i18n("none"), NONE_LOG_LEVEL_ICON, TQColor(208, 210, 220));
	Globals::logLevels.append(Globals::noneLogLevel);
		
	Globals::debugLogLevel=new LogLevel(DEBUG_LOG_LEVEL_ID, i18n("debug"), DEBUG_LOG_LEVEL_ICON, TQColor(156, 157, 165));
	Globals::logLevels.append(debugLogLevel);
	
	Globals::informationLogLevel=new LogLevel(INFORMATION_LOG_LEVEL_ID, i18n("information"), INFORMATION_LOG_LEVEL_ICON, TQColor(36, 49, 103) /*TQColor(0, 0, 0)*/);
	Globals::logLevels.append(Globals::informationLogLevel);
	
	Globals::noticeLogLevel=new LogLevel(NOTICE_LOG_LEVEL_ID, i18n("notice"), NOTICE_LOG_LEVEL_ICON, TQColor(36, 138, 22));
	Globals::logLevels.append(Globals::noticeLogLevel);
	
	Globals::warningLogLevel=new LogLevel(WARNING_LOG_LEVEL_ID, i18n("warning"), WARNING_LOG_LEVEL_ICON, TQColor(238, 144, 21));
	Globals::logLevels.append(Globals::warningLogLevel);
	
	Globals::errorLogLevel=new LogLevel(ERROR_LOG_LEVEL_ID, i18n("error"), ERROR_LOG_LEVEL_ICON, TQColor(173, 28, 28));
	Globals::logLevels.append(Globals::errorLogLevel);
	
	Globals::criticalLogLevel=new LogLevel(CRITICAL_LOG_LEVEL_ID, i18n("critical"), CRITICAL_LOG_LEVEL_ICON, TQColor(214, 26, 26));
	Globals::logLevels.append(criticalLogLevel);
	
	Globals::alertLogLevel=new LogLevel(ALERT_LOG_LEVEL_ID, i18n("alert"), ALERT_LOG_LEVEL_ICON, TQColor(214, 0, 0));
	Globals::logLevels.append(alertLogLevel);
	
	Globals::emergencyLogLevel=new LogLevel(EMERGENCY_LOG_LEVEL_ID, i18n("emergency"), EMERGENCY_LOG_LEVEL_ICON, TQColor(255, 0, 0));
	Globals::logLevels.append(emergencyLogLevel);
	
}

LogModes Globals::logModes;

LogMode* Globals::noMode=NULL;
LogMode* Globals::openingMode=NULL;
LogMode* Globals::systemMode=NULL;
LogMode* Globals::kernelMode=NULL;
LogMode* Globals::xorgMode=NULL;
LogMode* Globals::bootMode=NULL;
LogMode* Globals::authenticationMode=NULL;
LogMode* Globals::cronMode=NULL;
LogMode* Globals::daemonMode=NULL;

LogMode* Globals::acpidMode=NULL;
LogMode* Globals::cupsMode=NULL;
LogMode* Globals::cupsAccessMode=NULL;

LogMode* Globals::apacheMode=NULL;
LogMode* Globals::apacheAccessMode=NULL;

LogMode* Globals::mailMode=NULL;

LogMode* Globals::sambaMode=NULL;

void Globals::setupLogModes() {
	int i=0;
	
	Globals::noMode=new LogMode(i++, i18n("No Log"), NO_MODE_ICON);
	Globals::logModes.append(noMode);
	
	Globals::openingMode=new LogMode(i++, i18n("File Log"), OPENING_MODE_ICON);
	Globals::logModes.append(openingMode);
	
	Globals::systemMode=new LogMode(i++, i18n("System Log"), SYSTEM_MODE_ICON);
	Globals::logModes.append(systemMode);

	Globals::kernelMode=new LogMode(i++, i18n("Kernel Log"), KERNEL_MODE_ICON);
	Globals::logModes.append(kernelMode);

	Globals::xorgMode=new LogMode(i++, i18n("X.org Log"), XORG_MODE_ICON);
	Globals::logModes.append(xorgMode);

	Globals::sambaMode=new LogMode(i++, i18n("Samba Log"), SAMBA_MODE_ICON);
	Globals::logModes.append(sambaMode);

	Globals::bootMode=new LogMode(i++, i18n("Boot Log"), BOOT_MODE_ICON);
	Globals::logModes.append(bootMode);

	Globals::authenticationMode=new LogMode(i++, i18n("Authentication Log"), AUTHENTICATION_MODE_ICON);
	Globals::logModes.append(authenticationMode);
	
	Globals::cronMode=new LogMode(i++, i18n("Planned Tasks Cron Log"), CRON_MODE_ICON);
	Globals::logModes.append(cronMode);
	
	Globals::daemonMode=new LogMode(i++, i18n("Daemon Log"), DAEMON_MODE_ICON);
	Globals::logModes.append(daemonMode);

	Globals::acpidMode=new LogMode(i++, i18n("ACPI Log"), ACPID_MODE_ICON);
	Globals::logModes.append(acpidMode);
	
	Globals::cupsMode=new LogMode(i++, i18n("CUPS Log"), CUPS_MODE_ICON);
	Globals::logModes.append(cupsMode);

	Globals::cupsAccessMode=new LogMode(i++, i18n("CUPS Access Log"), CUPS_ACCESS_MODE_ICON);
	Globals::logModes.append(cupsAccessMode);

	Globals::apacheMode=new LogMode(i++, i18n("Apache Log"), APACHE_MODE_ICON);
	Globals::logModes.append(apacheMode);
	
	Globals::apacheAccessMode=new LogMode(i++, i18n("Apache Access Log"), APACHE_ACCESS_MODE_ICON);
	Globals::logModes.append(apacheAccessMode);
	
	Globals::mailMode=new LogMode(i++, i18n("Mail Log"), MAIL_MODE_ICON);
	Globals::logModes.append(mailMode);

	Globals::sambaMode=new LogMode(i++, i18n("Samba Log"), SAMBA_MODE_ICON);
	Globals::logModes.append(sambaMode);

}
