/* This file is part of the KDE project
   Copyright (C) 2002 Laurent Montel <lmontel@mandrakesoft.com>
   Copyright (c) 2003 Lukas Tinkl <lukas@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef OoImpress_IMPORT_H__
#define OoImpress_IMPORT_H__

#include <KoFilter.h>
#include <KoStore.h>

#include <tqdom.h>
#include <tqdict.h>
#include <tqcolor.h>
#include <KoStyleStack.h>
#include <liststylestack.h>

class KZip;

struct animationList
{
    TQDomElement *element;
    int order;
};

class OoImpressImport : public KoFilter
{
    TQ_OBJECT
  
public:
    OoImpressImport( KoFilter * parent, const char * name, const TQStringList & );
    virtual ~OoImpressImport();

    virtual KoFilter::ConversionStatus convert( TQCString const & from, TQCString const & to );

private:
    void createDocumentInfo( TQDomDocument &docinfo );
    void createDocumentContent( TQDomDocument &doccontent );
    void createStyleMap( TQDomDocument &docstyles );
    void insertDraws( const TQDomElement& styles );
    void insertStyles( const TQDomElement& styles );
    void insertStylesPresentation( const TQDomElement& styles );

    void fillStyleStack( const TQDomElement& object,bool sticky = false );
    void addStyles( const TQDomElement* style );
    void appendName(TQDomDocument& doc, TQDomElement& e, const TQDomElement& object);
    void append2DGeometry( TQDomDocument& doc, TQDomElement& e, const TQDomElement& object, int offset );
    bool appendLineGeometry( TQDomDocument& doc, TQDomElement& e, const TQDomElement& object, int offset );
    void appendPoints(TQDomDocument& doc, TQDomElement& e, const TQDomElement& object);
    void appendPie( TQDomDocument& doc, TQDomElement& e, const TQDomElement& object );
    void appendImage( TQDomDocument& doc, TQDomElement& e, TQDomElement& p, const TQDomElement& object );
    void appendBackgroundImage( TQDomDocument& doc, TQDomElement& e, TQDomElement& p, const TQDomElement& object );
    void appendBackgroundGradient( TQDomDocument& doc, TQDomElement& e, const TQDomElement& object );
    void appendRounding( TQDomDocument& doc, TQDomElement& e, const TQDomElement& object );
    void appendPen( TQDomDocument& doc, TQDomElement& e );
    void appendBrush( TQDomDocument& doc, TQDomElement& e );
    void appendShadow( TQDomDocument& doc, TQDomElement& e );
    void appendLineEnds( TQDomDocument& doc, TQDomElement& e, bool _orderEndStartLine = true );
    void appendTextObjectMargin( TQDomDocument& doc, TQDomElement& e );
    void appendField(TQDomDocument& doc, TQDomElement& e, const TQDomElement& object, uint pos);
    void createPresentationAnimation(const TQDomElement& element);
    TQDomElement findAnimationByObjectID(const TQString & id,  int & order);

    void appendObjectEffect(TQDomDocument& doc, TQDomElement& e, const TQDomElement& object, TQDomElement& sound);
    void appendBackgroundPage( TQDomDocument &doc, TQDomElement &e,TQDomElement & pictureElement,  TQDomElement &soundElement );

    TQDomElement saveHelper(const TQString &tmpText, TQDomDocument &doc);
    void appendObject(TQDomNode & drawPage,  TQDomDocument & doc,  TQDomElement & soundElement, TQDomElement & pictureElement, TQDomElement & pageNoteElement, TQDomElement &objectElement,double offset, bool sticky = false);

    TQString storeImage( const TQDomElement& object );
    TQString storeSound(const TQDomElement & object, TQDomElement & p, TQDomDocument & doc);
    TQDomElement parseTextBox( TQDomDocument& doc, const TQDomElement& textBox );
    bool pushListLevelStyle( const TQString& listStyleName, int level );
    bool pushListLevelStyle( const TQString& listStyleName, TQDomElement& fullListStyle, int level );
    void applyListStyle( TQDomElement& paragraph );
    void parseList( TQDomDocument& doc, TQDomElement& textObjectElement, const TQDomElement& list );
    void parseParagraphs( TQDomDocument& doc, TQDomElement& textObjectElement, const TQDomElement& textBox );
    TQDomElement parseParagraph( TQDomDocument& doc, const TQDomElement& paragraph );
    void parseSpanOrSimilar( TQDomDocument& doc, const TQDomElement& parent,
                             TQDomElement& outputParagraph, uint& pos);
    bool parseSettings( TQDomDocument &doc, TQDomElement &helpLineElement, TQDomElement &attributeElement );
    void parseHelpLine( TQDomDocument &doc,TQDomElement &helpLineElement, const TQString &text );

    KoFilter::ConversionStatus openFile();
    KoFilter::ConversionStatus loadAndParse(const TQString& filename, TQDomDocument& doc);

    int m_numPicture;
    int m_numSound;
    TQDomDocument    m_content;
    TQDomDocument    m_meta;
    TQDomDocument    m_settings;
    TQDict<TQDomElement> m_styles, m_draws, m_stylesPresentation;
    TQDict<TQDomElement>   m_listStyles;
    TQDict<animationList> m_animations;

    bool m_insideOrderedList;
    bool m_nextItemIsListItem; // only the first elem inside list-item is numbered
    int m_restartNumbering;
    TQString m_currentListStyleName;

    KZip * m_zip;
    KoStyleStack m_styleStack;
    ListStyleStack m_listStyleStack;
};

#endif
