/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/

#include "kmfruleeditmac.h"

#include <tqcheckbox.h>
#include <tqframe.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqvariant.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <kdebug.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <tdeapplication.h>

// project includes
#include "../../core/xmlnames.h"
#include "../../core/iptrule.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfcheckinput.h"
#include "../../core/kmferror.h"
#include "../../core/kmferrorhandler.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"

namespace KMF {
/*
 *  Constructs a KMFRuleEditMac which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  true to construct a modal dialog.
 */
KMFRuleEditMac::KMFRuleEditMac( TQWidget* parent, const char* name, WFlags fl )
		: KMyFirewallRuleEditorMac( parent, name, fl ) {
	m_err_handler = new KMFErrorHandler( "KMFRuleEditMac" );
	m_check_input = new KMFCheckInput();
	m_err = new KMFError();


}

/*
 *  Destroys the object and frees any allocated resources
 */
KMFRuleEditMac::~KMFRuleEditMac() {
	// no need to delete child widgets, TQt does it all for us
}

/*
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool KMFRuleEditMac::event( TQEvent* ev ) {
	bool ret = TQWidget::event( ev );
	if ( ev->type() == TQEvent::ApplicationFontChange ) {}
	return ret;
}

void KMFRuleEditMac::loadRule( IPTRule * rule ) {
	kdDebug() << "void KMFRuleEditMac::loadRule( IPTRule * rule )" << endl,
	c_src_mac->setChecked( false );
	c_inv_src_mac->setChecked( false );
	t_src_mac1 ->clear();
	t_src_mac2 ->clear();
	t_src_mac3 ->clear();
	t_src_mac4 ->clear();
	t_src_mac5 ->clear();
	t_src_mac6 ->clear();
	m_rule = rule;
	TQString line = "";

	IPTRuleOption* opt = 0;
	opt = m_rule->getOptionForName("mac_opt");
	if ( opt ) {
		TQStringList args = opt->getValues();
		TQString src, dest;
		line = *args.at(1);
		if ( line.isEmpty() || line == XML::Undefined_Value  )
			return;
		if ( line.startsWith( "! " ) ) {
			kdDebug() << "Found Invert Flag" << endl;
			line = line.right( line.length() - 2 );
			c_inv_src_mac->setChecked( true );
		}
		
		line = line.simplifyWhiteSpace();
		
		kdDebug() << "Found Mac Address: " << line << endl;
		if ( line == XML::BoolOff_Value ) {
			t_src_mac1 -> setText( "" );
			t_src_mac2 -> setText( "" );
			t_src_mac3 -> setText( "" );
			t_src_mac4 -> setText( "" );
			t_src_mac5 -> setText( "" );
			t_src_mac6 -> setText( "" );
			c_src_mac->setChecked( false );
			return;
		}
		
		int num = 1;
		TQString part = "";
		c_src_mac->setChecked( true );
		while ( !line.isEmpty() ) {
			int pos = -1;
			pos = line.find( ":" );
			if ( pos < 0 ) {
				part = line;
				kdDebug() << "Found last digit: " << part << endl;
				line = "";
			} else {
				kdDebug() << "found delim: " << pos << endl;
				part = line.left( pos );
				kdDebug() << "Token Nr." << num << ": " << part << endl;
				line = line.right( line.length() - ( pos + 1 ) );
				kdDebug() << "Rest: " << line << endl;
			}
			switch ( num ) {
				case 1:
					t_src_mac1 -> setText( part );
					break;
				case 2:
					t_src_mac2 -> setText( part );
					break;
				case 3:
					t_src_mac3 -> setText( part );
					break;
				case 4:
					t_src_mac4 -> setText( part );
					break;
				case 5:
					t_src_mac5 -> setText( part );
					break;
				case 6:
					t_src_mac6 -> setText( part );
					break;
			}
			num++;
		}
	}
}


void KMFRuleEditMac::accept() {
	kdDebug() << "KMFRuleEditMac::accept()" << endl;
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 MAC Option").arg( m_rule->name() ) 
	);
	TQString tok1 = t_src_mac1->text().upper();
	TQString tok2 = t_src_mac2->text().upper();
	TQString tok3 = t_src_mac3->text().upper();
	TQString tok4 = t_src_mac4->text().upper();
	TQString tok5 = t_src_mac5->text().upper();
	TQString tok6 = t_src_mac6->text().upper();

	if ( c_src_mac->isChecked() && ( tok1.isEmpty() || tok2.isEmpty() || tok3.isEmpty() || tok4.isEmpty() || tok5.isEmpty() || tok6.isEmpty() ) ) {
		const TQString & msg = i18n( "One ore more of the fields are empty. Please fill out all fields to define a valid MAC address." );
		KMessageBox::error( this, msg );
		KMFUndoEngine::instance()->abortTransaction();
		return ;
	}

	TQString mac = "";

	if ( c_src_mac->isChecked() ) {
		mac = tok1 + ":" + tok2 + ":" + tok3 + ":" + tok4 + ":" + tok5 + ":" + tok6;
		m_check_input->checkInput( mac, "MAC", m_err );
		if ( ! m_err_handler->showError( m_err ) ) {
			KMFUndoEngine::instance()->endTransaction();
			return ;
		}
	}

	TQPtrList<TQString>* values = new TQPtrList<TQString>;
	TQString* op = new TQString( "mac_opt" );
	if ( c_src_mac->isChecked() && !mac.isEmpty() ) {
		kdDebug() << "Add new mac option" << endl;
		TQString* src_mac = new TQString( mac );
		if ( c_inv_src_mac->isChecked() ) {
			src_mac->prepend( "! " );
		}
		values->append( new TQString( XML::BoolOn_Value ) );
		values->append( src_mac );
	} else {
		values->append( new TQString( XML::BoolOff_Value ) );
	}
	
	m_rule->addRuleOption( *op, *values );
	KMFUndoEngine::instance()->endTransaction();
	emit sigHideMe();
}

void KMFRuleEditMac::slotHelp() {
	kdDebug() << "void KMFRuleEditMac::slotHelp()" << endl;
	kapp->invokeHelp( "src_mac" );
}
void KMFRuleEditMac::reject() {
	kdDebug() << "void KMFRuleEditMac::reject()" << endl;
	emit sigHideMe();
}

}

#include "kmfruleeditmac.moc"
