/* ============================================================
 * File  : gallerywidget.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-12-01
 * Copyright 2004 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef GALLERYWIDGET_H
#define GALLERYWIDGET_H

#include <tqwidget.h>

class TQListView;
class TQPushButton;
class TQSpinBox;
class TQCheckBox;
class TDEHTMLPart;

namespace KIPIGalleryExportPlugin
{

class GalleryWidget : public TQWidget
{
    TQ_OBJECT
  
    
public:

    GalleryWidget( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~GalleryWidget();

private slots:

    void slotResizeChecked();

private:

    TQListView*    m_albumView;
    TDEHTMLPart*    m_photoView;
    TQPushButton*  m_newAlbumBtn;
    TQPushButton*  m_addPhotoBtn;
    TQCheckBox*    m_captTitleCheckBox;
    TQCheckBox*    m_captDescrCheckBox;
    TQCheckBox*    m_resizeCheckBox;
    TQSpinBox*     m_dimensionSpinBox;

    friend class GalleryWindow;
};

}

#endif // GALLERYWIDGET_H
