/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2005-17-06
 * Description : a kipi plugin to export images to Flickr web service
 *
 * Copyright (C) 2005-2008 by Vardhman Jain <vardhman at gmail dot com>
 * Copyright (C) 2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef FLICKRWINDOW_H
#define FLICKRWINDOW_H

// TQt includes.

#include <tqvaluelist.h>
#include <tqpair.h>
#include <tqintdict.h>

// KDE includes.

#include <kdialogbase.h>

// Libkipi includes.

#include <libkipi/interface.h>
#include <libkipi/imagedialog.h>

// Local includes

#include "kpaboutdata.h"

class TQPushButton;
class TQSpinBox;
class TQCheckBox;
class TQProgressDialog;

class KLineEdit;
class TDEHTMLPart;
class KURL;

namespace KIPI
{
class Interface;
}

namespace TDEWallet
{
class Wallet;
}

namespace KIPIFlickrExportPlugin
{

class FlickrWidget;
class FlickrTalker;
class FPhotoInfo;
class FPhotoSet;
class GPhoto;
class GAlbum;
class GAlbumViewItem;
class ImagesList;

class FlickrWindow : public KDialogBase
{
    TQ_OBJECT
  

public:

    FlickrWindow(KIPI::Interface *interface, const TQString &tmpFolder, TQWidget *parent);
    ~FlickrWindow();

private slots:

    void slotTokenObtained(const TQString& token);
    void slotDoLogin();
    void slotBusy(bool val);
    void slotError(const TQString& msg);

//  void slotLoginFailed( const TQString& msg );
//  void slotAlbums( const TQValueList<GAlbum>& albumList );
//  void slotPhotos( const TQValueList<GPhoto>& photoList );
//  void slotTagSelected();
//  void slotOpenPhoto( const KURL& url );

    void slotNewPhotoSet();
    void slotUserChangeRequest();
    void slotListPhotoSetsResponse(const TQValueList <FPhotoSet>& photoSetList);
    void slotAddPhotoNext();
    void slotAddPhotoSucceeded();
    void slotAddPhotoFailed(const TQString& msg);
    void slotAddPhotoCancel();
    void slotAuthCancel();
    void slotHelp();
    void slotClose();
    void slotUser1();
    void slotImageListChanged(bool);

private:

    void readSettings();
    void writeSettings();

private:

    unsigned int                           m_uploadCount;
    unsigned int                           m_uploadTotal;

//  TQPushButton                           *m_newAlbumBtn;
    TQPushButton                           *m_changeUserButton;

    TQCheckBox                             *m_resizeCheckBox;
    TQCheckBox                             *m_publicCheckBox;
    TQCheckBox                             *m_familyCheckBox;
    TQCheckBox                             *m_friendsCheckBox;
    TQCheckBox                             *m_exportHostTagsCheckBox;
    TQCheckBox                             *m_stripSpaceTagsCheckBox;

    TQSpinBox                              *m_dimensionSpinBox;
    TQSpinBox                              *m_imageQualitySpinBox;

    TQIntDict<GAlbumViewItem>               m_albumDict;

    TQString                                m_token;
    TQString                                m_username;
    TQString                                m_userId;
    TQString                                m_lastSelectedAlbum;
    TQString                                m_tmp;

    TQLabel                                *m_userNameDisplayLabel;

    TQProgressDialog                       *m_progressDlg;
    TQProgressDialog                       *m_authProgressDlg;

    TQValueList< TQPair<KURL, FPhotoInfo> >  m_uploadQueue;

//  TDEWallet::Wallet                       *m_wallet;
    TDEHTMLPart                             *m_photoView;

    KLineEdit                             *m_tagsLineEdit;

    FlickrWidget                          *m_widget;
    FlickrTalker                          *m_talker;

    ImagesList                            *m_imglst;

    KIPI::Interface                       *m_interface;

    KIPIPlugins::KPAboutData              *m_about;
};

} // namespace KIPIFlickrExportPlugin

#endif /* FLICKRWINDOW_H */
