/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#ifndef _BACKUP_H_
#define _BACKUP_H_

#include <tqstringlist.h>

class Backup 
{
public:
	Backup( TQString source, TQString dest, int m_interval, int m_deleteAfter, bool m_neverDelete,bool useCompression,bool excludeSpecialFiles,bool useAdvancedConfig,TQStringList optionList,bool useIncludeExclude,TQStringList includeExcludeList);
	Backup();
	~Backup();

	TQString source();	
	void setSource(TQString source);
	TQString dest();
	void setDest(TQString dest);
	int interval();
	void setInterval(int interval);
	int deleteAfter();
	void setDeleteAfter(int deleteAfter);
	bool neverDelete();
	void setNeverDelete(bool neverDelete);
	bool useCompression();
	void setUseCompression(bool useCompression);
	bool excludeSpecialFiles();
	void setExcludeSpecialFiles(bool excludeSpecialFiles);
	bool useAdvancedConfig();
	void setUseAdvancedConfig(bool useAdvancedConfig);
	TQStringList optionList();
	void setOptionList(TQStringList optionList);
	bool useIncludeExclude();
	void setUseIncludeExclude(bool useIncludeExclude);
	TQStringList includeExcludeList();
	void setIncludeExcludeList(TQStringList includeExcludeList);

	TQString htmlDesc();

private:
	TQString m_source;
	TQString m_dest;
	int m_interval;
	int m_deleteAfter;
	bool m_neverDelete;
	bool m_useCompression;
	bool m_excludeSpecialFiles;
	bool m_useAdvancedConfig;
	TQStringList m_optionList;
	bool m_useIncludeExclude;
	TQStringList m_includeExcludeList;
};

#endif
