//
// C++ Interface: k9config
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9CONFIG_H
#define K9CONFIG_H
#include "k9common.h"

#include <ksimpleconfig.h>
#include <kstandarddirs.h>

/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/
class k9Config {
private:
    KSimpleConfig *m_config;
    int  m_InputDev;
    int  m_OutputDev;
    bool m_keepMenus;
    TQString m_prefOutput;
    TQString m_prefVersion;
    bool m_useDvdAuthor;
    bool m_quickScan;
    int  m_prefSize;
    bool m_prefK3b;
    bool m_prefMenu;
    bool m_prefAutoBurn;
    int  m_prefMp4Codec;
    int  m_prefMp4AudioCodec;
    int  m_prefMp4AudioGain;
    int  m_prefMp4Size;
    int  m_prefMp4NumberCD;
    int  m_prefAudioBitrate;
    int  m_prefButtonWidth;
    int  m_prefButtonHeight;
    bool m_prefMp4AspectRatio;
    bool m_prefMp42Passes;
    bool m_prefDelTmpFiles;
    bool m_prefUseCellCache;
    TQString  m_prefMp4Width;
    TQString  m_prefMp4Height;
    TQString  m_prefMp4AudioBitrate;
    TQString  m_prefMp4VideoBitrate;
    TQString  m_prefAudioFormat;
    TQStringList m_codecAudio;
    TQStringList m_codecLabelsAudio;
    TQStringList m_codecLabels;
    TQStringList m_codecVideo;
    TQString m_prefCodecAudio,m_prefCodecVideo,m_prefCodecLabel;

    TQStringList m_devices;
    TQStringList m_devicesLabels;
    TQStringList m_devicesIO;

    TQColor  m_prefButtonHiliteColor;
    TQColor  m_prefButtonTextColor;
    TQFont   m_prefButtonFont;

    bool m_useMplayer;
    bool m_useGL;
    int  m_MplayerVout;
    int m_MplayerAout;
public:
    k9Config();
    void read();
    void save();
    ~k9Config();

    void setInputDev(const int& _value) {
        m_InputDev = _value;
    }


    int getInputDev() const {
        return m_InputDev;
    }

    void setOutputDev(const int& _value) {
        m_OutputDev = _value;
    }


    int getOutputDev() const {
        return m_OutputDev;
    }

    void setKeepMenus(bool _value) {
        m_keepMenus = _value;
    }


    bool getKeepMenus() const {
        return m_keepMenus;
    }

    void setPrefOutput(const TQString& _value) {
        m_prefOutput = _value;
    }

    TQString getPrefOutput() const {
        return m_prefOutput;
    }

    void setPrefAudioFormat( const TQString &_value) {
        m_prefAudioFormat=_value;
    }

    TQString getPrefAudioFormat() const {
        return m_prefAudioFormat;
    }

    void setPrefVersion(const TQString& _value) {
        m_prefVersion = _value;
    }

    TQString getPrefVersion() const {
        return m_prefVersion;
    }

    void setUseDvdAuthor(bool _value) {
        m_useDvdAuthor = _value;
    }


    bool getUseDvdAuthor() const {
        return m_useDvdAuthor;
    }

    void setPrefDelTmpFiles( bool _value) {
        m_prefDelTmpFiles=_value;
    }

    bool getPrefDelTmpFiles() const {
        return m_prefDelTmpFiles;
    }

    void setPrefUseCellCache( bool _value) {
        m_prefUseCellCache=_value;
    }

    bool getPrefUseCellCache() const {
        return m_prefUseCellCache;
    }
    void setQuickScan(bool _value) {
        m_quickScan = _value;
    }


    bool getQuickScan() const {
        return m_quickScan;
    }

    void setPrefSize(const int& _value) {
        m_prefSize = _value;
    }


    int getPrefSize() const {
        return m_prefSize;
    }

    void setPrefK3b(bool _value) {
        m_prefK3b = _value;
    }


    bool getPrefK3b() const {
        return m_prefK3b;
    }

    void setPrefMenu(bool _value) {
        m_prefMenu = _value;
    }


    bool getPrefMenu() const {
        return m_prefMenu;
    }

    void setPrefAutoBurn(bool _value) {
        m_prefAutoBurn = _value;
    }


    bool getPrefAutoBurn() const {
        return m_prefAutoBurn;
    }

    void setPrefMp4Codec(const int& _value) {
        m_prefMp4Codec = _value;
    }

    int getPrefMp4Codec() const {
        return m_prefMp4Codec;
    }

    void setPrefMp4AudioCodec(const int& _value) {
        m_prefMp4AudioCodec = _value;
    }

    int getPrefMp4AudioCodec() const {
        return m_prefMp4AudioCodec;
    }


    void setPrefMp4Size(const int& _value) {
        m_prefMp4Size = _value;
    }


    int getPrefMp4Size() const {
        return m_prefMp4Size;
    }

    void setPrefMp4AudioGain(const int& _value) {
        m_prefMp4AudioGain = _value;
    }


    int getPrefMp4AudioGain() const {
        return m_prefMp4AudioGain;
    }

    void setPrefMp4NumberCD(const int& _value) {
        m_prefMp4NumberCD = _value;
    }


    int getPrefMp4NumberCD() const {
        return m_prefMp4NumberCD;
    }

    void setPrefMp4Width(const TQString& _value) {
        m_prefMp4Width = _value;
    }


    TQString getPrefMp4Width() const {
        return m_prefMp4Width;
    }

    void setPrefMp4Height(const TQString& _value) {
        m_prefMp4Height = _value;
    }


    TQString getPrefMp4Height() const {
        return m_prefMp4Height;
    }

    void setPrefMp4AudioBitrate(const TQString& _value) {
        m_prefMp4AudioBitrate = _value;
    }


    TQString getPrefMp4AudioBitrate() const {
        return m_prefMp4AudioBitrate;
    }

    void setPrefMp4VideoBitrate(const TQString& _value) {
        m_prefMp4VideoBitrate = _value;
    }


    TQString getPrefMp4VideoBitrate() const {
        return m_prefMp4VideoBitrate;
    }

    void setCodecAudio(const TQStringList& _value) {
        m_codecAudio = _value;
    }


    TQStringList getCodecAudio() const {
        return m_codecAudio;
    }

    void setCodecLabels(const TQStringList& _value) {
        m_codecLabels = _value;
    }


    TQStringList getCodecLabels() const {
        return m_codecLabels;
    }

    void setCodecVideo(const TQStringList& _value) {
        m_codecVideo = _value;
    }


    TQStringList getCodecVideo() const {
        return m_codecVideo;
    }


    void setCodecLabelsAudio(const TQStringList& _value) {
        m_codecLabelsAudio = _value;
    }


    TQStringList getCodecLabelsAudio() const {
        return m_codecLabelsAudio;
    }


    void setDevices(const TQStringList& _value) {
        m_devices = _value;
    }


    TQStringList getDevices() const {
        return m_devices;
    }

    void setDevicesLabels(const TQStringList& _value) {
        m_devicesLabels = _value;
    }


    TQStringList getDevicesLabels() const {
        return m_devicesLabels;
    }

    void setDevicesIO(const TQStringList& _value) {
        m_devicesIO = _value;
    }


    TQStringList getDevicesIO() const {
        return m_devicesIO;
    }

    void setUseMplayer(bool _value) {
        m_useMplayer = _value;
    }


    bool getUseMplayer() const {
        return m_useMplayer;
    }

    void setUseGL(bool _value) {
        m_useGL = _value;
    }


    bool getUseGL() const {
        return m_useGL;
    }

    void setPrefMp4AspectRatio(bool _value) {
        m_prefMp4AspectRatio = _value;
    }


    bool getPrefMp4AspectRatio() const {
        return m_prefMp4AspectRatio;
    }

    void setPrefMp42Passes(bool _value) {
        m_prefMp42Passes = _value;
    }


    bool getPrefMp42Passes() const {
        return m_prefMp42Passes;
    }

    void setMplayerVout(const int& _value) {
        m_MplayerVout = _value;
    }


    int getMplayerVout() const {
        return m_MplayerVout;
    }

    void setMplayerAout(const int& _value) {
        m_MplayerAout = _value;
    }


    int getMplayerAout() const {
        return m_MplayerAout;
    }

    void setPrefAudioBitrate(int _value) {
        m_prefAudioBitrate = _value;
    }


    int getPrefAudioBitrate() const {
        return m_prefAudioBitrate;
    }

    void setPrefButtonWidth(int _value) {
        m_prefButtonWidth = _value;
    }


    int getPrefButtonWidth() const {
        return m_prefButtonWidth;
    }

    void setPrefButtonHeight(int _value) {
        m_prefButtonHeight = _value;
    }


    int getPrefButtonHeight() const {
        return m_prefButtonHeight;
    }

    void setPrefButtonHiliteColor(const TQColor& _value) {
        m_prefButtonHiliteColor = _value;
    }


    TQColor getPrefButtonHiliteColor() const {
        return m_prefButtonHiliteColor;
    }

    void setPrefButtonTextColor(const TQColor& _value) {
        m_prefButtonTextColor = _value;
    }


    TQColor getPrefButtonTextColor() const {
        return m_prefButtonTextColor;
    }


    void setPrefButtonFont(const TQFont& _value) {
        m_prefButtonFont = _value;
    }


    TQFont getPrefButtonFont() const {
        return m_prefButtonFont;
    }

};

#endif
