/* The TdeGtk Theming Engine for Gtk+.
 * Copyright (C) 2012 Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Portions of this file written by
 * Andrea Cimitan <andrea.cimitan@canonical.com>
 *
 */

#ifndef TDEGTK_TYPES_H
#define TDEGTK_TYPES_H

#define DRAW_ARGS GtkThemingEngine *engine, \
                  cairo_t          *cr, \
                  gdouble           x, \
                  gdouble           y, \
                  gdouble           width, \
                  gdouble           height

G_BEGIN_DECLS

typedef struct _GtkCssBorderCornerRadius GtkCssBorderCornerRadius;
typedef struct _GtkCssBorderRadius GtkCssBorderRadius;

struct _GtkCssBorderCornerRadius {
  gdouble horizontal;
  gdouble vertical;
};

struct _GtkCssBorderRadius {
  GtkCssBorderCornerRadius top_left;
  GtkCssBorderCornerRadius top_right;
  GtkCssBorderCornerRadius bottom_right;
  GtkCssBorderCornerRadius bottom_left;
};

enum {
  SIDE_LEFT   = 1,
  SIDE_BOTTOM = 1 << 1,
  SIDE_RIGHT  = 1 << 2,
  SIDE_TOP    = 1 << 3,
  SIDE_ALL    = 0xF
};

typedef enum
{
  TDEGTK_STYLE_DEFAULT = 0,
  TDEGTK_NUM_STYLES = 1
} TdeGtkStyles;

enum TQt3WidgetType {
	TQT3WT_NONE,
	TQT3WT_TQProgressBar,
	TQT3WT_TQTabBar,
	TQT3WT_TQRadioButton,
	TQT3WT_TQCheckBox,
	TQT3WT_TQPushButton,
	TQT3WT_TQPopupMenu,
	TQT3WT_TQMenuItem,
	TQT3WT_TQMenuBarItem,
	TQT3WT_TQComboBox,
	TQT3WT_TQSlider,
	TQT3WT_TQScrollBar,
	TQT3WT_TQSpinBox,
	TQT3WT_TQSpinWidget,
	TQT3WT_TQTitleBar,
	TQT3WT_TQMenuBar,
	TQT3WT_TQToolBox,
	TQT3WT_TQToolButton,
	TQT3WT_TQGroupBox,
	TQT3WT_TQLineEdit,
	TQT3WT_GTKTreeViewCell,
};

typedef struct _TdeGtkStyleFunctions TdeGtkStyleFunctions;

struct _TdeGtkStyleFunctions
{
  void (*draw_activity) (DRAW_ARGS);

  void (*draw_arrow) (GtkThemingEngine *engine,
                      cairo_t          *cr,
                      gdouble           angle,
                      gdouble           x,
                      gdouble           y,
                      gdouble           size);

  void (*draw_cell_background) (DRAW_ARGS,
                                GtkRegionFlags flags);

  void (*draw_cell_frame) (DRAW_ARGS,
                           GtkRegionFlags flags);

  void (*draw_check) (DRAW_ARGS);

  void (*draw_common) (DRAW_ARGS);

  void (*draw_common_background) (DRAW_ARGS);

  void (*draw_common_frame) (DRAW_ARGS);

  void (*draw_expander) (DRAW_ARGS);

  void (*draw_extension) (DRAW_ARGS,
                          GtkPositionType gap_side);

  void (*draw_focus) (DRAW_ARGS);

  void (*draw_frame_gap) (DRAW_ARGS,
                          GtkPositionType gap_side,
                          gdouble         xy0_gap,
                          gdouble         xy1_gap);

  void (*draw_grip) (DRAW_ARGS);

  void (*draw_handle) (DRAW_ARGS);

  void (*draw_line) (GtkThemingEngine *engine,
                     cairo_t          *cr,
                     gdouble           x0,
                     gdouble           y0,
                     gdouble           x1,
                     gdouble           y1);

  void (*draw_notebook) (DRAW_ARGS,
                         GtkPositionType gap_side,
                         gdouble         xy0_gap,
                         gdouble         xy1_gap);

  void (*draw_radio) (DRAW_ARGS);

  void (*draw_separator) (DRAW_ARGS);

  void (*draw_slider) (DRAW_ARGS,
                       GtkOrientation orientation);

  void (*draw_spinbutton_background) (DRAW_ARGS);

  void (*draw_spinbutton_frame) (DRAW_ARGS);
};

G_END_DECLS

#endif /* TDEGTK_TYPES_H */
