/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.utils.URIUtils;

public class ResourceConnection {
    private InputStream stream;
    private URI uri;
    private URI redirect;
    private int statusCode;
    private String contentType;
    private String etag;
    private Long lastModified;
    private Long date;
    private CloseableHttpClient httpclient;

    public ResourceConnection(ResolverConfiguration config, String resolved) {
        this(config, resolved, false);
    }

    public ResourceConnection(ResolverConfiguration config, String resolved, boolean headOnly) {
        block14: {
            this.stream = null;
            this.uri = null;
            this.redirect = null;
            this.statusCode = -1;
            this.contentType = null;
            this.etag = null;
            this.lastModified = -1L;
            this.date = -1L;
            this.httpclient = null;
            try {
                this.uri = URIUtils.newURI(resolved);
                URL url = this.uri.toURL();
                if ("http".equals(this.uri.getScheme()) || "https".equals(this.uri.getScheme())) {
                    Date d2;
                    this.httpclient = HttpClients.createDefault();
                    HttpClientContext context = HttpClientContext.create();
                    Object httpreq = null;
                    httpreq = headOnly ? new HttpHead(this.uri) : new HttpGet(this.uri);
                    CloseableHttpResponse httpResponse = this.httpclient.execute((ClassicHttpRequest)httpreq, (HttpContext)context);
                    HttpHost target = context.getHttpRoute().getTargetHost();
                    RedirectLocations redirectLocations = context.getRedirectLocations();
                    URI location = org.apache.hc.client5.http.utils.URIUtils.resolve((URI)httpreq.getUri(), (HttpHost)target, (List)redirectLocations.getAll());
                    this.redirect = this.uri.equals(location) ? null : location;
                    this.statusCode = httpResponse.getCode();
                    this.contentType = this.getHeader((HttpResponse)httpResponse, "Content-Type", "application/octet-stream");
                    this.etag = this.getHeader((HttpResponse)httpResponse, "Etag", null);
                    if (!headOnly) {
                        this.stream = ((ClassicHttpResponse)httpResponse).getEntity().getContent();
                    }
                    SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    String dateString = this.getHeader((HttpResponse)httpResponse, "Last-Modified", null);
                    if (dateString != null) {
                        try {
                            d2 = format.parse(dateString);
                            this.lastModified = d2.getTime();
                        }
                        catch (ParseException d2) {
                            // empty catch block
                        }
                    }
                    if ((dateString = this.getHeader((HttpResponse)httpResponse, "Date", null)) != null) {
                        try {
                            d2 = format.parse(dateString);
                            this.date = d2.getTime();
                        }
                        catch (ParseException parseException) {}
                    }
                    break block14;
                }
                URLConnection connection = url.openConnection();
                connection.connect();
                if (headOnly) {
                    connection.getInputStream().close();
                } else {
                    this.stream = connection.getInputStream();
                }
                this.contentType = null;
                this.etag = connection.getHeaderField("Etag");
                this.lastModified = connection.getLastModified();
                this.date = connection.getDate();
                try {
                    HttpURLConnection http = (HttpURLConnection)connection;
                    this.statusCode = http.getResponseCode();
                }
                catch (ClassCastException ex) {
                    this.statusCode = 200;
                }
            }
            catch (IOException | IllegalArgumentException | URISyntaxException use) {
                ResolverLogger logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
                logger.log("warning", "Failed to %s: %s: %s", headOnly ? "HEAD" : "GET", resolved, use.getMessage());
            }
        }
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEtag() {
        return this.etag;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getRedirect() {
        return this.redirect;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getDate() {
        return this.date;
    }

    public void close() {
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getHeader(HttpResponse resp, String name, String def) {
        Header[] headers = resp.getHeaders(name);
        if (headers == null) {
            return def;
        }
        if (headers.length == 0) {
            return def;
        }
        return headers[0].getValue();
    }
}

