/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasource.descriptor;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Comparator;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasupport.Positionable;
import org.graalvm.visualvm.core.model.Model;

public abstract class DataSourceDescriptor<X extends DataSource>
extends Model
implements Positionable {
    public static final String PROPERTY_ICON = "prop_icon";
    public static final String PROPERTY_NAME = "prop_name";
    public static final String PROPERTY_DESCRIPTION = "prop_description";
    public static final String PROPERTY_PREFERRED_POSITION = "prop_preferred_position";
    public static final String PROPERTY_CHILDREN_COMPARATOR = "prop_children_comparator";
    public static final String PROPERTY_EXPANSION_POLICY = "prop_expansion_policy";
    public static final int EXPAND_NEVER = 0;
    public static final int EXPAND_ON_FIRST_CHILD = 1;
    public static final int EXPAND_ON_EACH_FIRST_CHILD = 2;
    public static final int EXPAND_ON_EACH_NEW_CHILD = 3;
    public static final int EXPAND_ON_EACH_CHILD_CHANGE = 4;
    private X dataSource;
    private Image icon;
    private String name;
    private String description;
    private int preferredPosition;
    private Comparator<DataSource> childrenComparator;
    private int autoExpansionPolicy;
    private final PropertyChangeSupport changeSupport;

    public DataSourceDescriptor(X dataSource) {
        this(dataSource, dataSource != null ? dataSource.toString() : null, null, null, 0x7FFFFFFE, 1);
    }

    public DataSourceDescriptor(X ds, String n, String desc, Image ic, int pos, int aep) {
        if (ds == null) {
            throw new NullPointerException("DataSource cannot be null");
        }
        this.dataSource = ds;
        this.changeSupport = new PropertyChangeSupport(this.dataSource);
        this.name = this.formatName(n);
        this.description = desc;
        this.icon = ic;
        this.preferredPosition = pos;
        this.autoExpansionPolicy = aep;
    }

    public Image getIcon() {
        return this.icon;
    }

    public boolean supportsRename() {
        return false;
    }

    public void setName(String newName) {
        this.setNameImpl(newName, PROPERTY_NAME);
    }

    protected void setImplicitName(String newName, String propertyName) {
        this.setNameImpl(newName, propertyName);
    }

    private void setNameImpl(String newName, String propertyName) {
        if (!this.supportsRename()) {
            throw new UnsupportedOperationException("Rename not supported for this descriptor");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String oldName = this.name;
        this.name = this.formatName(newName);
        if (propertyName != null) {
            ((DataSource)this.getDataSource()).getStorage().setCustomProperty(propertyName, newName);
        }
        this.getChangeSupport().firePropertyChange(PROPERTY_NAME, oldName, this.getName());
    }

    public String getName() {
        return this.name;
    }

    protected String formatName(String namePattern) {
        return namePattern;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int getPreferredPosition() {
        return this.preferredPosition;
    }

    public Comparator<DataSource> getChildrenComparator() {
        return this.childrenComparator;
    }

    public int getAutoExpansionPolicy() {
        return this.autoExpansionPolicy;
    }

    public boolean providesProperties() {
        return false;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    protected final X getDataSource() {
        return this.dataSource;
    }

    protected void setDescription(String newDescription) {
        if (this.description == null && newDescription == null) {
            return;
        }
        String oldDescription = this.description;
        this.description = newDescription;
        this.getChangeSupport().firePropertyChange(PROPERTY_DESCRIPTION, oldDescription, this.getDescription());
    }

    protected void setIcon(Image newIcon) {
        if (this.icon == null && newIcon == null) {
            return;
        }
        Image oldIcon = this.icon;
        this.icon = newIcon;
        this.getChangeSupport().firePropertyChange(PROPERTY_ICON, oldIcon, this.getIcon());
    }

    protected void setPreferredPosition(int newPosition) {
        int oldPosition = this.preferredPosition;
        this.preferredPosition = newPosition;
        this.getChangeSupport().firePropertyChange(PROPERTY_PREFERRED_POSITION, oldPosition, this.getPreferredPosition());
    }

    protected void setChildrenComparator(Comparator<DataSource> newComparator) {
        Comparator<DataSource> oldComparator = this.childrenComparator;
        this.childrenComparator = newComparator;
        this.getChangeSupport().firePropertyChange(PROPERTY_CHILDREN_COMPARATOR, oldComparator, this.getChildrenComparator());
    }

    protected void getAutoExpansionPolicy(int newPolicy) {
        int oldPolicy = this.autoExpansionPolicy;
        this.autoExpansionPolicy = newPolicy;
        this.getChangeSupport().firePropertyChange(PROPERTY_EXPANSION_POLICY, oldPolicy, this.getAutoExpansionPolicy());
    }

    protected final PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    protected static String resolveName(DataSource dataSource, String name) {
        String persistedName = dataSource.getStorage().getCustomProperty(PROPERTY_NAME);
        if (persistedName != null) {
            return persistedName;
        }
        return name;
    }

    protected static int resolvePosition(DataSource dataSource, int position, boolean savePosition) {
        Storage storage = dataSource.getStorage();
        String positionS = storage.getCustomProperty(PROPERTY_PREFERRED_POSITION);
        if (positionS != null) {
            try {
                position = Integer.parseInt(positionS);
            }
            catch (NumberFormatException e) {
                if (savePosition) {
                    storage.setCustomProperty(PROPERTY_PREFERRED_POSITION, Integer.toString(position));
                }
            }
        } else if (savePosition) {
            storage.setCustomProperty(PROPERTY_PREFERRED_POSITION, Integer.toString(position));
        }
        return position;
    }
}

