/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph.layout;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.model.ObjectScene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniversalGraph<N, E> {
    public abstract ObjectScene getScene();

    public abstract Collection<N> getNodes();

    public abstract Collection<E> getEdges();

    public abstract Collection<E> findNodeEdges(N var1, boolean var2, boolean var3);

    public abstract N getEdgeSource(E var1);

    public abstract N getEdgeTarget(E var1);

    static <N, E> UniversalGraph<N, E> createUniversalGraph(final GraphScene<N, E> graphScene) {
        return new UniversalGraph<N, E>(){

            @Override
            public ObjectScene getScene() {
                return graphScene;
            }

            @Override
            public Collection<N> getNodes() {
                return graphScene.getNodes();
            }

            @Override
            public Collection<E> getEdges() {
                return graphScene.getEdges();
            }

            @Override
            public Collection<E> findNodeEdges(N n, boolean bl, boolean bl2) {
                return graphScene.findNodeEdges(n, bl, bl2);
            }

            @Override
            public N getEdgeSource(E e) {
                return graphScene.getEdgeSource(e);
            }

            @Override
            public N getEdgeTarget(E e) {
                return graphScene.getEdgeTarget(e);
            }
        };
    }

    static <N, E, P> UniversalGraph<N, E> createUniversalGraph(final GraphPinScene<N, E, P> graphPinScene) {
        return new UniversalGraph<N, E>(){

            @Override
            public ObjectScene getScene() {
                return graphPinScene;
            }

            @Override
            public Collection<N> getNodes() {
                return graphPinScene.getNodes();
            }

            @Override
            public Collection<E> getEdges() {
                return graphPinScene.getEdges();
            }

            @Override
            public Collection<E> findNodeEdges(N n, boolean bl, boolean bl2) {
                ArrayList arrayList = new ArrayList();
                for (Object p : graphPinScene.getNodePins(n)) {
                    arrayList.addAll(graphPinScene.findPinEdges(p, bl, bl2));
                }
                return arrayList;
            }

            @Override
            public N getEdgeSource(E e) {
                return graphPinScene.getPinNode(graphPinScene.getEdgeSource(e));
            }

            @Override
            public N getEdgeTarget(E e) {
                return graphPinScene.getPinNode(graphPinScene.getEdgeTarget(e));
            }
        };
    }
}

