/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import de.escape.quincunx.gimmicks.ProgressShower;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class Bargauge
extends Component
implements ProgressShower {
    private static final int BORDER_WIDTH = 2;
    private static final int DEFAULT_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 16;
    private static final int BAR_STEPS = 35;
    private static final int BAR_ADVANCE = 5;
    private static final long MIN_BAR_WAIT = 70L;
    private float filled;
    private Color fillColor = Color.red;
    private int borderWidth = 2;
    private Dimension preferredSize = new Dimension(0, 0);
    private int lastFill = -1;
    private Image buffer;
    private int barPos;
    private int barDir = 1;
    private boolean barMode = false;
    private long barUpdate;

    public Bargauge() {
        this(200, 16);
    }

    public Bargauge(int width, int height) {
        this.preferredSize.width = width;
        this.preferredSize.height = height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public Dimension getMinimalSize() {
        return new Dimension(this.preferredSize);
    }

    public synchronized void setFillLevel(float fill) {
        this.barMode = false;
        if (fill > 1.0f) {
            fill = 1.0f;
        } else if (fill < 0.0f) {
            fill = 0.0f;
        }
        if (fill != this.filled) {
            this.filled = fill;
            if ((int)((float)(this.getSize().width - 2 * this.borderWidth) * this.filled) != this.lastFill) {
                this.update(this.getGraphics());
            }
        }
    }

    public void setFillLevel(float fill, float maxfill) {
        this.setFillLevel(fill / maxfill);
    }

    public void setFillLevel(long fill, long maxfill) {
        this.setFillLevel((float)fill / (float)maxfill);
    }

    public void advanceBar() {
        boolean doUpdate = false;
        if (!this.barMode) {
            this.barMode = true;
            this.barPos = 0;
            this.barDir = 1;
            doUpdate = true;
        } else if (System.currentTimeMillis() > this.barUpdate) {
            this.barPos += this.barDir;
            if (this.barPos >= 35) {
                this.barPos = 33;
                this.barDir = -1;
            } else if (this.barPos < 0) {
                this.barPos = 1;
                this.barDir = 1;
            }
            doUpdate = true;
        }
        if (doUpdate) {
            this.update(this.getGraphics());
            this.barUpdate = System.currentTimeMillis() + 70L;
        }
    }

    public void setColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Graphics bufg;
        Dimension size = this.getSize();
        if (this.buffer == null || size.width != this.buffer.getWidth(this) || size.height != this.buffer.getHeight(this)) {
            this.buffer = this.createImage(size.width, size.height);
            if (this.buffer == null) {
                return;
            }
            this.lastFill = -1;
            bufg = this.buffer.getGraphics();
            bufg.setColor(this.getBackground());
            int i = 0;
            while (i < this.borderWidth) {
                bufg.draw3DRect(i, i, size.width - 2 * i - 1, size.height - 2 * i - 1, false);
                ++i;
            }
        } else {
            bufg = this.buffer.getGraphics();
        }
        if (!this.barMode) {
            int fill = (int)((float)(size.width - 2 * this.borderWidth) * this.filled);
            if (fill != this.lastFill) {
                this.lastFill = fill;
                bufg.setColor(this.getBackground());
                if (fill > 0) {
                    bufg.setColor(this.fillColor);
                    bufg.fillRect(this.borderWidth, this.borderWidth, fill, size.height - 2 * this.borderWidth);
                }
                if (fill < size.width - 2 * this.borderWidth - 1) {
                    bufg.setColor(this.getBackground());
                    bufg.fillRect(fill + this.borderWidth, this.borderWidth, size.width - 2 * this.borderWidth - fill, size.height - 2 * this.borderWidth);
                }
            }
        } else {
            int barWidth = 5 * (size.width - 2 * this.borderWidth) / 39;
            int begin = this.borderWidth + barWidth * this.barPos / 5;
            bufg.setColor(this.getBackground());
            bufg.fillRect(this.borderWidth, this.borderWidth, size.width - 2 * this.borderWidth, size.height - 2 * this.borderWidth);
            bufg.setColor(this.fillColor);
            bufg.fillRect(begin, this.borderWidth, barWidth, size.height - 2 * this.borderWidth);
        }
        g.drawImage(this.buffer, 0, 0, this);
    }

    public void showProgress() {
        this.advanceBar();
    }

    public void showProgress(float level) {
        this.setFillLevel(level);
    }

    public void showProgress(float level, float maxLevel) {
        this.setFillLevel(level, maxLevel);
    }

    public void showProgress(long level, long maxLevel) {
        this.setFillLevel(level, maxLevel);
    }
}

