/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml.acs;

import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.ValidationError;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;

public class AssertedIdentity {
    private final SamlResponse response;
    private final String username;
    private final Map<String, List<String>> attributes;

    public AssertedIdentity(SamlResponse response) throws GuacamoleException {
        Map responseAttributes;
        String nameId;
        try {
            nameId = response.getNameId();
            if (nameId == null) {
                throw new GuacamoleSecurityException("SAML response did not include the relevant user's identity (no name ID).");
            }
        }
        catch (Exception e) {
            throw new GuacamoleSecurityException("User identity (name ID) could not be retrieved from the SAML response: " + e.getMessage(), (Throwable)e);
        }
        try {
            responseAttributes = Collections.unmodifiableMap(response.getAttributes());
        }
        catch (ValidationError | XPathExpressionException e) {
            throw new GuacamoleSecurityException("SAML attributes could not be parsed from the SAML response: " + e.getMessage(), e);
        }
        this.response = response;
        this.username = nameId.toLowerCase();
        this.attributes = responseAttributes;
    }

    public String getUsername() {
        return this.username;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public boolean isValid() {
        return this.response.isValid();
    }
}

