/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ByteBuilder {
    private static final Logger logger = LogManager.getLogger(ByteBuilder.class);
    private byte[] array;
    private int size;

    public ByteBuilder() {
        this(10);
    }

    public ByteBuilder(int capacity) {
        this.array = new byte[capacity];
        this.size = 0;
    }

    public ByteBuilder(byte[] array) {
        this.array = Arrays.copyOf(array, array.length * 2);
        this.size = array.length;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.array.length) {
            this.array = Arrays.copyOf(this.array, capacity);
        }
    }

    private void testAddition(int addition) {
        while (this.size + addition >= this.array.length) {
            this.array = Arrays.copyOf(this.array, this.array.length * 2);
        }
    }

    private void copyIntoArray(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.array[this.size + i] = b[i];
        }
        this.size += b.length;
    }

    public int capacity() {
        return this.array.length;
    }

    public int size() {
        return this.size;
    }

    public void truncate(int size) {
        this.array = Arrays.copyOf(this.array, size);
    }

    public byte[] subSequence(int start, int end) {
        return Arrays.copyOfRange(this.array, start, end);
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    public String toString() {
        return new String(this.array, 0, this.size);
    }

    public ByteBuilder append(byte value) {
        this.testAddition(1);
        this.array[this.size++] = value;
        return this;
    }

    public ByteBuilder append(byte[] value) {
        return this.append(value, 0, value.length);
    }

    public ByteBuilder append(byte[] value, int offset, int len) {
        if (offset + len > value.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.testAddition(len);
        for (int i = 0; i < len; ++i) {
            this.array[this.size + i] = value[i + offset];
        }
        this.size += len;
        return this;
    }

    public ByteBuilder append(char value) {
        this.testAddition(1);
        this.array[this.size++] = (byte)value;
        return this;
    }

    public ByteBuilder append(char[] value) {
        return this.append(value, 0, value.length);
    }

    public ByteBuilder append(char[] value, int offset, int len) {
        if (offset + len > value.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.testAddition(len);
        for (int i = 0; i < len; ++i) {
            this.array[this.size + i] = (byte)value[i + offset];
        }
        this.size += len;
        return this;
    }

    public ByteBuilder append(boolean value) {
        this.testAddition(1);
        this.array[this.size++] = (byte)(value ? 1 : 0);
        return this;
    }

    public ByteBuilder append(short value) {
        int LEN = 2;
        this.testAddition(2);
        byte[] b = new byte[2];
        for (int i = 0; i < 2; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        this.copyIntoArray(b);
        return this;
    }

    public ByteBuilder append(int value) {
        int LEN = 4;
        this.testAddition(4);
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        this.copyIntoArray(b);
        return this;
    }

    public ByteBuilder append(long value) {
        int LEN = 8;
        this.testAddition(8);
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFFL);
        }
        this.copyIntoArray(b);
        return this;
    }

    public ByteBuilder append(float value) {
        int LEN = 4;
        this.testAddition(4);
        int intval = Float.floatToRawIntBits(value);
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(intval >>> offset & 0xFF);
        }
        this.copyIntoArray(b);
        return this;
    }

    public ByteBuilder append(double value) {
        int LEN = 8;
        this.testAddition(8);
        long intval = Double.doubleToRawLongBits(value);
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(intval >>> offset & 0xFFL);
        }
        this.copyIntoArray(b);
        return this;
    }

    public ByteBuilder append(Object value) {
        try {
            Method bytem = value.getClass().getMethod("toByteStructure", null);
            byte[] array = (byte[])bytem.invoke(value, new Object[0]);
            return this.append(array);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return this.append(value.toString());
    }

    public ByteBuilder append(String value) {
        return this.append(value, Charset.defaultCharset());
    }

    public ByteBuilder append(String value, Charset charset) {
        byte[] b = value.getBytes(charset);
        this.testAddition(b.length + 4);
        return this.append(b.length).append(b);
    }

    public ByteBuilder append(StringBuffer value) {
        return this.append(value, Charset.defaultCharset());
    }

    public ByteBuilder append(StringBuffer value, Charset charset) {
        byte[] b = value.toString().getBytes(charset);
        this.testAddition(b.length + 4);
        return this.append(b.length).append(b);
    }

    public ByteBuilder append(ByteBuilder value) {
        this.testAddition(value.size);
        return this.append(value.array, 0, value.size);
    }

    public ByteBuilder appendSpecial(long value, int length, boolean preserveNegative) {
        this.testAddition(length);
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFFL);
            if (!preserveNegative || i != 0) continue;
            if (value < 0L) {
                int n = i;
                b[n] = (byte)(b[n] | 0x80);
                continue;
            }
            int n = i;
            b[n] = (byte)(b[n] & 0x7F);
        }
        this.copyIntoArray(b);
        return this;
    }
}

