/*
 * Decompiled with CFR 0.152.
 */
package org.nibor.autolink;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.internal.EmailScanner;
import org.nibor.autolink.internal.Scanner;
import org.nibor.autolink.internal.UrlScanner;
import org.nibor.autolink.internal.WwwScanner;

public class LinkExtractor {
    private final Scanner urlScanner;
    private final Scanner wwwScanner;
    private final Scanner emailScanner;

    private LinkExtractor(UrlScanner urlScanner, WwwScanner wwwScanner, EmailScanner emailScanner) {
        this.urlScanner = urlScanner;
        this.wwwScanner = wwwScanner;
        this.emailScanner = emailScanner;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Iterable<LinkSpan> extractLinks(final CharSequence input) {
        return new Iterable<LinkSpan>(){

            @Override
            public Iterator<LinkSpan> iterator() {
                return new LinkIterator(input);
            }
        };
    }

    private Scanner trigger(char c) {
        switch (c) {
            case ':': {
                return this.urlScanner;
            }
            case '@': {
                return this.emailScanner;
            }
            case 'w': {
                return this.wwwScanner;
            }
        }
        return null;
    }

    private class LinkIterator
    implements Iterator<LinkSpan> {
        private final CharSequence input;
        private LinkSpan next = null;
        private int index = 0;
        private int rewindIndex = 0;

        public LinkIterator(CharSequence input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            this.setNext();
            return this.next != null;
        }

        @Override
        public LinkSpan next() {
            if (this.hasNext()) {
                LinkSpan link = this.next;
                this.next = null;
                return link;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private void setNext() {
            if (this.next != null) {
                return;
            }
            int length = this.input.length();
            while (this.index < length) {
                Scanner scanner = LinkExtractor.this.trigger(this.input.charAt(this.index));
                if (scanner != null) {
                    LinkSpan link = scanner.scan(this.input, this.index, this.rewindIndex);
                    if (link != null) {
                        this.next = link;
                        this.rewindIndex = this.index = link.getEndIndex();
                        break;
                    }
                    ++this.index;
                    continue;
                }
                ++this.index;
            }
        }
    }

    public static class Builder {
        private Set<LinkType> linkTypes = EnumSet.allOf(LinkType.class);
        private boolean emailDomainMustHaveDot = true;

        private Builder() {
        }

        public Builder linkTypes(Set<LinkType> linkTypes) {
            if (linkTypes == null) {
                throw new NullPointerException("linkTypes must not be null");
            }
            this.linkTypes = new HashSet<LinkType>(linkTypes);
            return this;
        }

        public Builder emailDomainMustHaveDot(boolean emailDomainMustHaveDot) {
            this.emailDomainMustHaveDot = emailDomainMustHaveDot;
            return this;
        }

        public LinkExtractor build() {
            UrlScanner urlScanner = this.linkTypes.contains((Object)LinkType.URL) ? new UrlScanner() : null;
            WwwScanner wwwScanner = this.linkTypes.contains((Object)LinkType.WWW) ? new WwwScanner() : null;
            EmailScanner emailScanner = this.linkTypes.contains((Object)LinkType.EMAIL) ? new EmailScanner(this.emailDomainMustHaveDot) : null;
            return new LinkExtractor(urlScanner, wwwScanner, emailScanner);
        }
    }
}

