/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest.root.debug;

import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.jitsi.health.HealthCheckService;
import org.jitsi.health.Result;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.StatsKeepingNode;
import org.jitsi.nlj.transform.node.debug.PayloadVerificationPlugin;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.queue.QueueStatistics;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.rest.RestApis;
import org.jitsi.videobridge.rest.annotations.EnabledByConfig;
import org.jitsi.videobridge.rest.root.debug.DebugFeatures;
import org.jitsi.videobridge.rest.root.debug.EndpointDebugFeatures;
import org.jitsi.videobridge.stats.ConferencePacketStats;
import org.jitsi.videobridge.stats.PacketTransitStats;
import org.jitsi.videobridge.stats.QueueStats;
import org.jitsi.videobridge.transport.ice.IceStatistics;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.json.simple.JSONObject;

@Path(value="/debug")
@EnabledByConfig(value=RestApis.DEBUG)
public class Debug {
    @Inject
    private Videobridge videobridge;
    @Inject
    private HealthCheckService healthCheckService;
    private final Logger logger = new LoggerImpl(Debug.class.getName());

    @POST
    @Path(value="/features/jvb/{feature}/{enabled}")
    public Response setJvbFeatureState(@PathParam(value="feature") DebugFeatures feature, @PathParam(value="enabled") Boolean enabled2) {
        this.logger.info((enabled2 != false ? "Enabling" : "Disabling") + " feature " + feature.getValue());
        this.setFeature(feature, enabled2);
        return Response.ok().build();
    }

    @GET
    @Path(value="/features/jvb/{feature}/{enabled}")
    public Response setJvbFeatureState2(@PathParam(value="feature") DebugFeatures feature, @PathParam(value="enabled") Boolean enabled2) {
        this.logger.info((enabled2 != false ? "Enabling" : "Disabling") + " feature " + feature.getValue());
        this.setFeature(feature, enabled2);
        return Response.ok().build();
    }

    @GET
    @Path(value="/features/jvb/{feature}")
    public Boolean getJvbFeatureState(@PathParam(value="feature") DebugFeatures feature) {
        switch (feature) {
            case PAYLOAD_VERIFICATION: {
                return Node.Companion.isPayloadVerificationEnabled();
            }
            case NODE_STATS: {
                return StatsKeepingNode.Companion.getEnableStatistics();
            }
            case POOL_STATS: {
                return ByteBufferPool.statisticsEnabled();
            }
            case POOL_BOOKKEEPING: {
                return ByteBufferPool.bookkeepingEnabled();
            }
            case QUEUE_STATS: {
                return QueueStatistics.DEBUG;
            }
            case QUEUE_TIMING_STATS: {
                return QueueStatistics.TRACK_TIMES;
            }
            case NODE_TRACING: {
                return Node.Companion.isNodeTracingEnabled();
            }
            case TRANSIT_STATS: {
                return true;
            }
            case TASK_POOL_STATS: {
                return true;
            }
            case TOSSED_PACKET_STATS: {
                return true;
            }
        }
        throw new NotFoundException();
    }

    @POST
    @Path(value="/features/endpoint/{confId}/{epId}/{feature}/{enabled}")
    public Response setEndpointFeatureState(@PathParam(value="confId") String confId, @PathParam(value="epId") String epId, @PathParam(value="feature") EndpointDebugFeatures feature, @PathParam(value="enabled") Boolean enabled2) {
        Conference conference = this.videobridge.getConference(confId);
        if (conference == null) {
            throw new NotFoundException("No conference was found with the specified id.");
        }
        Endpoint endpoint = conference.getLocalEndpoint(epId);
        if (endpoint == null) {
            throw new NotFoundException("No endpoint was found with the specified id.");
        }
        this.logger.info("Setting feature state: feature=" + feature.getValue() + ", enabled? " + enabled2);
        try {
            endpoint.setFeature(feature, enabled2);
        }
        catch (IllegalStateException e) {
            return Response.status(403, e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/features/endpoint/{confId}/{epId}/{feature}/")
    public Boolean getEndpointFeatureState(@PathParam(value="confId") String confId, @PathParam(value="epId") String epId, @PathParam(value="feature") EndpointDebugFeatures feature) {
        Conference conference = this.videobridge.getConference(confId);
        if (conference == null) {
            throw new NotFoundException("No conference was found with the specified id.");
        }
        Endpoint endpoint = conference.getLocalEndpoint(epId);
        if (endpoint == null) {
            throw new NotFoundException("No endpoint was found with the specified id.");
        }
        try {
            return endpoint.isFeatureEnabled(feature);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/features/relay/{confId}/{rId}/{feature}/{enabled}")
    public Response setRelayFeatureState(@PathParam(value="confId") String confId, @PathParam(value="rId") String rId, @PathParam(value="feature") EndpointDebugFeatures feature, @PathParam(value="enabled") Boolean enabled2) {
        Conference conference = this.videobridge.getConference(confId);
        if (conference == null) {
            throw new NotFoundException("No conference was found with the specified id.");
        }
        Relay relay = conference.getRelay(rId);
        if (relay == null) {
            throw new NotFoundException("No relay was found with the specified id.");
        }
        this.logger.info("Setting feature state: feature=" + feature.getValue() + ", enabled? " + enabled2);
        try {
            relay.setFeature(feature, enabled2);
        }
        catch (IllegalStateException e) {
            return Response.status(403, e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/features/relay/{confId}/{rId}/{feature}/")
    public Boolean getRelayFeatureState(@PathParam(value="confId") String confId, @PathParam(value="rId") String rId, @PathParam(value="feature") EndpointDebugFeatures feature) {
        Conference conference = this.videobridge.getConference(confId);
        if (conference == null) {
            throw new NotFoundException("No conference was found with the specified id.");
        }
        Relay relay = conference.getRelay(rId);
        if (relay == null) {
            throw new NotFoundException("No relay was found with the specified id.");
        }
        try {
            return relay.isFeatureEnabled(feature);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void setFeature(DebugFeatures feature, boolean enabled2) {
        switch (feature) {
            case PAYLOAD_VERIFICATION: {
                Node.Companion.enablePayloadVerification(enabled2);
                break;
            }
            case NODE_STATS: {
                StatsKeepingNode.Companion.setEnableStatistics(enabled2);
                break;
            }
            case POOL_STATS: {
                ByteBufferPool.enableStatistics(enabled2);
                break;
            }
            case POOL_BOOKKEEPING: {
                ByteBufferPool.enableBookkeeping(enabled2);
                break;
            }
            case QUEUE_STATS: {
                QueueStatistics.DEBUG = enabled2;
                break;
            }
            case QUEUE_TIMING_STATS: {
                QueueStatistics.TRACK_TIMES = enabled2;
                break;
            }
            case NODE_TRACING: {
                Node.Companion.enableNodeTracing(enabled2);
                break;
            }
            case TRANSIT_STATS: {
                break;
            }
            case TASK_POOL_STATS: {
                break;
            }
            default: {
                throw new NotFoundException();
            }
        }
    }

    @GET
    @Produces(value={"application/json"})
    public String bridgeDebug(@DefaultValue(value="false") @QueryParam(value="full") boolean full) {
        OrderedJsonObject debugState = this.videobridge.getDebugState(null, null, full);
        Result result = this.healthCheckService.getResult();
        JSONObject health = new JSONObject();
        health.put("success", result.getSuccess());
        health.put("hardFailure", result.getHardFailure());
        health.put("responseCode", result.getResponseCode());
        health.put("message", result.getMessage());
        debugState.put("health", health);
        return debugState.toJSONString();
    }

    @GET
    @Path(value="/{confId}")
    @Produces(value={"application/json"})
    public String confDebug(@PathParam(value="confId") String confId, @DefaultValue(value="true") @QueryParam(value="full") boolean full) {
        OrderedJsonObject confJson = this.videobridge.getDebugState(confId, null, full);
        return confJson.toJSONString();
    }

    @GET
    @Path(value="/{confId}/{epId}")
    @Produces(value={"application/json"})
    public String epDebug(@PathParam(value="confId") String confId, @PathParam(value="epId") String epId, @DefaultValue(value="true") @QueryParam(value="full") boolean full) {
        OrderedJsonObject confJson = this.videobridge.getDebugState(confId, epId, full);
        return confJson.toJSONString();
    }

    @GET
    @Path(value="/stats/jvb/{feature}")
    @Produces(value={"application/json"})
    public String getJvbFeatureStats(@PathParam(value="feature") DebugFeatures feature) {
        switch (feature) {
            case NODE_STATS: {
                return StatsKeepingNode.Companion.getStatsJson().toJSONString();
            }
            case POOL_STATS: {
                return ByteBufferPool.getStatsJson().toJSONString();
            }
            case QUEUE_STATS: {
                return QueueStats.getQueueStats().toJSONString();
            }
            case TRANSIT_STATS: {
                return PacketTransitStats.getStatsJson().toJSONString();
            }
            case TASK_POOL_STATS: {
                return TaskPools.getStatsJson().toJSONString();
            }
            case XMPP_DELAY_STATS: {
                return XmppConnection.getStatsJson().toJSONString();
            }
            case PAYLOAD_VERIFICATION: {
                return PayloadVerificationPlugin.getStatsJson().toJSONString();
            }
            case ICE_STATS: {
                return IceStatistics.Companion.getStats().toJson().toJSONString();
            }
            case CONFERENCE_PACKET_STATS: {
                return ConferencePacketStats.stats.toJson().toJSONString();
            }
            case TOSSED_PACKET_STATS: {
                return VideobridgeMetrics.tossedPacketsEnergy.get().toJSONString();
            }
        }
        throw new NotFoundException();
    }

    @Deprecated
    @GET
    @Path(value="/stats/{feature_name:.+}")
    @Produces(value={"application/json"})
    public Response getStats(@PathParam(value="feature_name") String featureName, @Context UriInfo uriInfo) {
        String newTarget = String.valueOf(uriInfo.getBaseUri()) + "debug/stats/jvb/" + featureName;
        return Response.status(302).location(URI.create(newTarget)).build();
    }
}

