/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;
import org.glassfish.jersey.message.internal.HttpDateFormat;

@Singleton
public class ParamConverters {

    @Singleton
    public static class AggregatedProvider
    implements ParamConverterProvider {
        private final ParamConverterProvider[] providers;

        @Inject
        public AggregatedProvider(@Context InjectionManager manager) {
            this.providers = new ParamConverterProvider[]{new DateProvider(), new TypeFromStringEnum(), new TypeValueOf(), new CharacterProvider(), new TypeFromString(), new StringConstructor(), new OptionalCustomProvider(manager), new OptionalProvider()};
        }

        @Override
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            for (ParamConverterProvider p : this.providers) {
                ParamConverter<T> reader = p.getConverter(rawType, genericType, annotations);
                if (reader == null) continue;
                return reader;
            }
            return null;
        }
    }

    @Singleton
    public static class OptionalProvider
    implements ParamConverterProvider {
        @Override
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Optionals optionals = Optionals.getOptional(rawType);
            return optionals == null ? null : new ParamConverter<T>(){

                @Override
                public T fromString(String value2) {
                    if (value2 == null || value2.isEmpty()) {
                        return optionals.empty();
                    }
                    return optionals.of(value2);
                }

                @Override
                public String toString(T value2) throws IllegalArgumentException {
                    return null;
                }
            };
        }

        private static enum Optionals {
            OPTIONAL_INT((Class)OptionalInt.class){

                @Override
                Object empty() {
                    return OptionalInt.empty();
                }

                @Override
                Object of(Object value2) {
                    return OptionalInt.of(Integer.parseInt((String)value2));
                }
            }
            ,
            OPTIONAL_DOUBLE((Class)OptionalDouble.class){

                @Override
                Object empty() {
                    return OptionalDouble.empty();
                }

                @Override
                Object of(Object value2) {
                    return OptionalDouble.of(Double.parseDouble((String)value2));
                }
            }
            ,
            OPTIONAL_LONG((Class)OptionalLong.class){

                @Override
                Object empty() {
                    return OptionalLong.empty();
                }

                @Override
                Object of(Object value2) {
                    return OptionalLong.of(Long.parseLong((String)value2));
                }
            };

            private final Class<?> clazz;

            private Optionals(Class<?> clazz) {
                this.clazz = clazz;
            }

            private static Optionals getOptional(Class<?> clazz) {
                for (Optionals optionals : Optionals.values()) {
                    if (optionals.clazz != clazz) continue;
                    return optionals;
                }
                return null;
            }

            abstract Object empty();

            abstract Object of(Object var1);
        }
    }

    @Singleton
    public static class OptionalCustomProvider
    implements ParamConverterProvider {
        private final InjectionManager manager;

        public OptionalCustomProvider(InjectionManager manager) {
            this.manager = manager;
        }

        @Override
        public <T> ParamConverter<T> getConverter(Class<T> rawType, final Type genericType, final Annotation[] annotations) {
            return rawType != Optional.class ? null : new ParamConverter<T>(){

                @Override
                public T fromString(String value2) {
                    if (value2 == null) {
                        return Optional.empty();
                    }
                    List<ClassTypePair> ctps = ReflectionHelper.getTypeArgumentAndClass(genericType);
                    ClassTypePair ctp = ctps.size() == 1 ? ctps.get(0) : null;
                    boolean empty = value2.isEmpty();
                    for (ParamConverterProvider provider : Providers.getProviders(manager, ParamConverterProvider.class)) {
                        ParamConverter<?> converter = provider.getConverter(ctp.rawClass(), ctp.type(), annotations);
                        if (converter == null) continue;
                        if (empty) {
                            return Optional.empty();
                        }
                        return Optional.of(value2).map(s2 -> converter.fromString(value2));
                    }
                    return null;
                }

                @Override
                public String toString(T value2) throws IllegalArgumentException {
                    return null;
                }
            };
        }
    }

    @Singleton
    public static class DateProvider
    implements ParamConverterProvider {
        @Override
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            return rawType != Date.class ? null : new ParamConverter<T>(){

                @Override
                public T fromString(String value2) {
                    if (value2 == null) {
                        throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
                    }
                    try {
                        return rawType.cast(HttpDateFormat.readDate(value2));
                    }
                    catch (ParseException ex) {
                        throw new ExtractorException(ex);
                    }
                }

                @Override
                public String toString(T value2) throws IllegalArgumentException {
                    if (value2 == null) {
                        throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
                    }
                    return value2.toString();
                }
            };
        }
    }

    @Singleton
    public static class CharacterProvider
    implements ParamConverterProvider {
        @Override
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (rawType.equals(Character.class)) {
                return new ParamConverter<T>(){

                    @Override
                    public T fromString(String value2) {
                        if (value2 == null || value2.isEmpty()) {
                            return null;
                        }
                        if (value2.length() == 1) {
                            return rawType.cast(Character.valueOf(value2.charAt(0)));
                        }
                        throw new ExtractorException(LocalizationMessages.ERROR_PARAMETER_INVALID_CHAR_VALUE(value2));
                    }

                    @Override
                    public String toString(T value2) {
                        if (value2 == null) {
                            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
                        }
                        return value2.toString();
                    }
                };
            }
            return null;
        }
    }

    @Singleton
    public static class TypeFromStringEnum
    extends TypeFromString {
        @Override
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            return !Enum.class.isAssignableFrom(rawType) ? null : super.getConverter(rawType, genericType, annotations);
        }
    }

    @Singleton
    public static class TypeFromString
    implements ParamConverterProvider {
        @Override
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Method fromStringMethod = AccessController.doPrivileged(ReflectionHelper.getFromStringStringMethodPA(rawType));
            return fromStringMethod == null ? null : new AbstractStringReader<T>(){

                @Override
                public T _fromString(String value2) throws Exception {
                    return rawType.cast(fromStringMethod.invoke(null, value2));
                }
            };
        }
    }

    @Singleton
    public static class TypeValueOf
    implements ParamConverterProvider {
        @Override
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Method valueOf = AccessController.doPrivileged(ReflectionHelper.getValueOfStringMethodPA(rawType));
            return valueOf == null ? null : new AbstractStringReader<T>(){

                @Override
                public T _fromString(String value2) throws Exception {
                    return rawType.cast(valueOf.invoke(null, value2));
                }
            };
        }
    }

    @Singleton
    public static class StringConstructor
    implements ParamConverterProvider {
        @Override
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Constructor constructor = AccessController.doPrivileged(ReflectionHelper.getStringConstructorPA(rawType));
            return constructor == null ? null : new AbstractStringReader<T>(){

                @Override
                protected T _fromString(String value2) throws Exception {
                    return rawType.cast(constructor.newInstance(value2));
                }
            };
        }
    }

    private static abstract class AbstractStringReader<T>
    implements ParamConverter<T> {
        private AbstractStringReader() {
        }

        @Override
        public T fromString(String value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
            }
            try {
                return this._fromString(value2);
            }
            catch (InvocationTargetException ex) {
                if (value2.isEmpty()) {
                    return null;
                }
                Throwable cause = ex.getCause();
                if (cause instanceof WebApplicationException) {
                    throw (WebApplicationException)cause;
                }
                throw new ExtractorException(cause);
            }
            catch (Exception ex) {
                throw new ProcessingException(ex);
            }
        }

        protected abstract T _fromString(String var1) throws Exception;

        @Override
        public String toString(T value2) throws IllegalArgumentException {
            if (value2 == null) {
                throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
            }
            return value2.toString();
        }
    }
}

