/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.enterprise.AbstractNetworkConflictResolver;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.Transient;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class PlayPenComponent
extends AbstractSPObject
implements Selectable {
    private static final Logger logger = Logger.getLogger(PlayPenComponent.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();
    protected Point topLeftCorner = new Point();
    private Dimension lengths = new Dimension();
    private Dimension minimumSize = new Dimension();
    protected Color backgroundColor;
    protected Color foregroundColor;
    private Insets insets = new Insets(0, 0, 0, 0);
    private String toolTipText;
    private boolean opaque;
    private PlayPenComponentUI ui;
    protected boolean selected;
    protected boolean componentPreviouslySelected;
    private boolean isBeingDragged = false;
    private final AbstractNetworkConflictResolver.UpdateListener updateWhileMovingListener = new AbstractNetworkConflictResolver.UpdateListener(){

        public boolean updatePerformed(AbstractNetworkConflictResolver resolver) {
            return true;
        }

        public boolean updateException(AbstractNetworkConflictResolver resolver, Throwable t) {
            return false;
        }

        public void preUpdatePerformed(AbstractNetworkConflictResolver resolver) {
            if (PlayPenComponent.this.isBeingDragged) {
                PlayPenComponent.this.doneDragging(false);
            }
        }

        public void workspaceDeleted() {
        }
    };
    private final List<SelectionListener> selectionListeners = new LinkedList<SelectionListener>();

    protected PlayPenComponent(String name) {
        this.setName(name);
    }

    protected PlayPenComponent(String name, PlayPenContentPane parent) {
        this(name);
        this.setParent((SPObject)parent);
    }

    protected PlayPenComponent(PlayPenComponent copyMe, PlayPenContentPane parent) {
        this(copyMe.getName(), parent);
        this.backgroundColor = copyMe.backgroundColor;
        if (copyMe.topLeftCorner != null) {
            this.topLeftCorner = new Point(copyMe.topLeftCorner);
        }
        if (copyMe.lengths != null) {
            this.lengths = new Dimension(copyMe.lengths);
        }
        this.componentPreviouslySelected = copyMe.componentPreviouslySelected;
        this.foregroundColor = copyMe.foregroundColor;
        if (copyMe.insets != null) {
            this.insets = new Insets(copyMe.insets.top, copyMe.insets.left, copyMe.insets.bottom, copyMe.insets.right);
        }
        if (copyMe.minimumSize != null) {
            this.minimumSize = new Dimension(copyMe.minimumSize);
        }
        this.opaque = copyMe.opaque;
        this.setParent((SPObject)parent);
        this.selected = copyMe.selected;
        this.toolTipText = copyMe.toolTipText;
    }

    @Transient
    @Accessor
    public PlayPen getPlayPen() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getPlayPen();
    }

    @Transient
    @Accessor
    public PlayPenComponentUI getUI() {
        return this.ui;
    }

    @Transient
    @Mutator
    public void setUI(PlayPenComponentUI ui) {
        PlayPenComponentUI oldValue = this.ui;
        this.ui = ui;
        this.firePropertyChange("UI", oldValue, ui);
    }

    public void showPopup(Point p) {
        JPopupMenu menu = this.getPopup(new Point(p));
        if (menu != null) {
            int xAdjust = 5;
            p.translate(this.getX(), this.getY());
            this.getPlayPen().zoomPoint(p);
            menu.show(this.getPlayPen(), p.x + 5, p.y);
        }
    }

    @NonBound
    public JPopupMenu getPopup(Point p) {
        return null;
    }

    public void revalidate() {
        PlayPen pp = this.getPlayPen();
        if (pp == null) {
            logger.debug((Object)"getPlayPen() returned null.  Not generating repaint request.");
            return;
        }
        this.setMagicEnabled(false);
        this.updateLengths(true);
        this.setMagicEnabled(true);
        Rectangle r = new Rectangle(this.topLeftCorner, this.lengths);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scheduling repaint at " + r));
        }
        pp.zoomRect(r);
        pp.repaint(r);
    }

    public void updateLengths(boolean revalidate) {
        PlayPenComponentUI ui = this.getUI();
        if (ui != null) {
            Dimension ps;
            if (revalidate) {
                ui.revalidate();
            }
            if ((ps = ui.getPreferredSize()) != null) {
                this.setLengths(ps);
            }
        }
    }

    @NonBound
    public Rectangle getBounds() {
        return this.getBounds(null);
    }

    @Accessor
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumSize);
    }

    @Mutator
    public void setMinimumSize(Dimension minimumSize) {
        Dimension oldMinimumSize = this.minimumSize;
        this.minimumSize = new Dimension(minimumSize);
        this.firePropertyChange("minimumSize", oldMinimumSize, new Dimension(minimumSize));
    }

    @NonBound
    public Rectangle getBounds(Rectangle r) {
        if (r == null) {
            r = new Rectangle();
        }
        r.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return r;
    }

    @Transient
    @Accessor(isInteresting=true)
    public Dimension getSize() {
        return this.lengths;
    }

    @Transient
    @Accessor
    public Point getPreferredLocation() {
        return this.getLocation();
    }

    @Transient
    @Accessor(isInteresting=true)
    public Point getLocation() {
        return this.getLocation(null);
    }

    @Transient
    @Accessor
    public Point getLocation(Point p) {
        if (p == null) {
            p = new Point();
        }
        p.setLocation(this.getTopLeftCorner());
        return p;
    }

    public void repaint() {
        this.repaint(this.getBounds());
    }

    public void repaint(Rectangle r) {
        this.repaint(0L, r.x, r.y, r.width, r.height);
    }

    @Transient
    @Accessor
    public abstract String getModelName();

    @Transient
    @Accessor
    public int getX() {
        return this.topLeftCorner.x;
    }

    @Transient
    @Accessor
    public int getY() {
        return this.topLeftCorner.y;
    }

    @Transient
    @Accessor
    public int getWidth() {
        return this.lengths.width;
    }

    @Transient
    @Accessor
    public int getHeight() {
        return this.lengths.height;
    }

    @Transient
    @Accessor
    public Insets getInsets() {
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    @Transient
    @Mutator
    public void setInsets(Insets insets) {
        Insets oldValue = this.insets;
        this.insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.firePropertyChange("insets", oldValue, insets);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        PlayPen owner = this.getPlayPen();
        if (owner == null) {
            return;
        }
        double zoom = owner.getZoom();
        int x1 = (int)Math.floor((double)x * zoom);
        int y1 = (int)Math.floor((double)y * zoom);
        int x2 = (int)Math.ceil((double)(x + width) * zoom);
        int y2 = (int)Math.ceil((double)(y + height) * zoom);
        if (owner.isRenderingAntialiased()) {
            --x1;
            --y1;
            ++x2;
            ++y2;
        }
        owner.repaint(x1, y1, x2 - x1, y2 - y1);
    }

    @Accessor(isInteresting=true)
    public boolean isOpaque() {
        return this.opaque;
    }

    @Mutator
    public void setOpaque(boolean opaque) {
        if (this.opaque != opaque) {
            this.opaque = opaque;
            this.firePropertyChange("opaque", !opaque, opaque);
        }
    }

    @Accessor(isInteresting=true)
    public Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            return this.getPlayPen().getBackground();
        }
        return this.backgroundColor;
    }

    @Mutator
    public void setBackgroundColor(Color c) {
        Color oldColor = this.backgroundColor;
        this.backgroundColor = c;
        this.firePropertyChange("backgroundColor", oldColor, this.backgroundColor);
    }

    @Accessor(isInteresting=true)
    public Color getForegroundColor() {
        if (this.foregroundColor == null && this.getPlayPen() != null) {
            return this.getPlayPen().getForeground();
        }
        return this.foregroundColor;
    }

    @Mutator
    public void setForegroundColor(Color c) {
        Color oldColor = this.getForegroundColor();
        this.foregroundColor = c;
        this.firePropertyChange("foregroundColor", oldColor, this.foregroundColor);
    }

    @Transient
    @Accessor
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Transient
    @Mutator
    public void setToolTipText(String toolTipText) {
        String oldValue = this.toolTipText;
        if (!ArchitectUtils.areEqual(toolTipText, this.toolTipText)) {
            this.toolTipText = toolTipText;
            this.firePropertyChange("tooTipText", oldValue, toolTipText);
            logger.debug((Object)("ToolTipText changed to " + toolTipText));
        }
    }

    @Transient
    @Accessor
    public Font getFont() {
        if (this.getPlayPen() == null) {
            return null;
        }
        return this.getPlayPen().getFont();
    }

    @Transient
    @Accessor
    public FontMetrics getFontMetrics(Font f) {
        return this.getPlayPen().getFontMetrics(f);
    }

    @Transient
    @Accessor
    public FontRenderContext getFontRenderContext() {
        return this.getPlayPen().getFontRenderContext();
    }

    public boolean contains(Point p) {
        boolean containsPoint = this.getUI().contains(p);
        logger.debug((Object)("" + this + " contains " + p + "? " + containsPoint));
        return containsPoint;
    }

    public void paint(Graphics2D g2) {
        this.getUI().paint(g2);
        if (logger.isDebugEnabled()) {
            Color oldColor = g2.getColor();
            g2.setColor(Color.ORANGE);
            g2.drawRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(oldColor);
        }
    }

    @Transient
    @Accessor
    public Dimension getPreferredSize() {
        return this.getUI().getPreferredSize();
    }

    @Accessor(isInteresting=true)
    public abstract Object getModel();

    public abstract void handleMouseEvent(MouseEvent var1);

    @Override
    public final void addSelectionListener(SelectionListener l) {
        logger.info((Object)("" + this + " is adding " + l));
        this.selectionListeners.add(l);
    }

    @Override
    public final void removeSelectionListener(SelectionListener l) {
        this.selectionListeners.remove(l);
    }

    protected final void fireSelectionEvent(SelectionEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notifying " + this.selectionListeners.size() + " listeners of selection change"));
        }
        Iterator<SelectionListener> it = this.selectionListeners.iterator();
        if (e.getType() == 1) {
            while (it.hasNext()) {
                it.next().itemSelected(e);
            }
        } else if (e.getType() == 2) {
            while (it.hasNext()) {
                it.next().itemDeselected(e);
            }
        } else {
            throw new IllegalStateException("Unknown selection event type " + e.getType());
        }
    }

    @Override
    @Transient
    @Accessor
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    @Transient
    @Mutator
    public void setSelected(boolean isSelected, int multiSelectType) {
        if (this.selected != isSelected) {
            this.selected = isSelected;
            this.fireSelectionEvent(new SelectionEvent(this, this.selected ? 1 : 2, multiSelectType));
            this.repaint();
        }
    }

    @NonBound
    public boolean isBeingDragged() {
        return this.isBeingDragged;
    }

    public void startedDragging() {
        if (!this.isBeingDragged) {
            this.isBeingDragged = true;
            if (this.getPlayPen().getSession().isEnterpriseSession()) {
                this.getPlayPen().getSession().getEnterpriseSession().getUpdater().addListener(this.updateWhileMovingListener);
            }
        } else {
            throw new IllegalStateException("Component is already in the middle of a drag");
        }
        this.getParent().begin("Dragging " + this);
    }

    public void doneDragging() {
        this.doneDragging(true);
    }

    public void doneDragging(boolean ok) {
        if (this.isBeingDragged) {
            this.isBeingDragged = false;
            if (ok) {
                this.getParent().commit("Done dragging " + this);
            } else {
                for (MouseMotionListener l : this.getPlayPen().getMouseMotionListeners()) {
                    if (!(l instanceof PlayPen.FloatingContainerPaneListener)) continue;
                    ((PlayPen.FloatingContainerPaneListener)l).cleanup();
                }
                this.getParent().rollback("Update received while dragging");
                JOptionPane.showMessageDialog(this.getPlayPen(), "There was an update while you were dragging");
            }
        } else {
            throw new IllegalStateException("Component is not in the middle of a drag");
        }
    }

    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @Accessor
    public PlayPenContentPane getParent() {
        return (PlayPenContentPane)super.getParent();
    }

    @Mutator
    public void setParent(SPObject parent) {
        if (!(parent instanceof PlayPenContentPane) && parent != null) {
            throw new IllegalArgumentException("Parent of PlayPenComponent must be PlayPenContentPane, not " + parent.getClass().getSimpleName());
        }
        super.setParent(parent);
    }

    public List<? extends SPObject> getChildren() {
        return Collections.emptyList();
    }

    public boolean removeChildImpl(SPObject child) {
        return false;
    }

    public List<? extends SPObject> getDependencies() {
        return Collections.singletonList((SPObject)this.getModel());
    }

    public void removeDependency(SPObject dependency) {
        if (dependency == this.getModel()) {
            try {
                this.getParent().removeChild((SPObject)this);
            }
            catch (ObjectDependentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void connect() {
    }

    @Transient
    @Accessor
    public Point getPointForModelObject(@Nonnull Object modelObject) {
        return this.getUI().getPointForModelObject(modelObject);
    }

    @Transient
    @Accessor
    public Point getLocationOnScreen() {
        Point p = new Point();
        PlayPen pp = this.getPlayPen();
        this.getLocation(p);
        pp.zoomPoint(p);
        SwingUtilities.convertPointToScreen(p, pp);
        return p;
    }

    @Mutator
    public void setTopLeftCorner(Point topLeftCorner) {
        this.repaint();
        Point old = this.topLeftCorner;
        this.topLeftCorner = topLeftCorner;
        this.firePropertyChange("topLeftCorner", old, topLeftCorner);
        this.repaint();
    }

    @Accessor
    public Point getTopLeftCorner() {
        return this.topLeftCorner;
    }

    @Transient
    @Mutator
    public void setLengths(Dimension lengths) {
        Dimension old = this.lengths;
        this.lengths = lengths;
        this.firePropertyChange("lengths", old, lengths);
    }

    @Transient
    @Accessor
    public Dimension getLengths() {
        return this.lengths;
    }

    @Transient
    @Mutator
    public void setBounds(Rectangle r) {
        this.setTopLeftCorner(new Point(r.x, r.y));
        this.setLengths(new Dimension(r.width, r.height));
    }

    @Transient
    @Mutator
    public void setBounds(int x, int y, int width, int height) {
        this.setTopLeftCorner(new Point(x, y));
        this.setLengths(new Dimension(width, height));
    }

    @Transient
    @Mutator
    public void setLocation(int x, int y) {
        this.setTopLeftCorner(new Point(x, y));
    }

    @Transient
    @Mutator
    public void setLocation(Point pos) {
        this.setTopLeftCorner(pos);
    }

    @Transient
    @Mutator
    public void setSize(Dimension size) {
        this.setBounds(this.getX(), this.getY(), size.width, size.height);
    }
}

