/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.object.AbstractPoolingSPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPVariableResolver;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;

public class SPResolverRegistry {
    private static final Logger logger = Logger.getLogger(SPResolverRegistry.class);
    private static Map<String, List<SPVariableResolver>> resolvers = Collections.synchronizedMap(new WeakHashMap());
    private static Map<String, TreeListener> listeners = Collections.synchronizedMap(new WeakHashMap());

    private SPResolverRegistry() {
    }

    private static SPObject getRoot(SPObject treeElement) {
        if (treeElement == null) {
            return null;
        }
        while (treeElement.getParent() != null) {
            treeElement = treeElement.getParent();
        }
        return treeElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SPObject init(SPObject treeElement) {
        if (treeElement == null) {
            return null;
        }
        Map<String, List<SPVariableResolver>> map = resolvers;
        synchronized (map) {
            SPObject root = SPResolverRegistry.getRoot(treeElement);
            if (!resolvers.containsKey(root.getUUID())) {
                resolvers.put(root.getUUID(), Collections.synchronizedList(new ArrayList()));
                listeners.put(root.getUUID(), new TreeListener());
                root.addSPListener(listeners.get(root.getUUID()));
            }
            return root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(SPObject treeMember, SPVariableResolver resolver) {
        if (treeMember != null && resolver != null) {
            Map<String, List<SPVariableResolver>> map = resolvers;
            synchronized (map) {
                SPObject root = SPResolverRegistry.init(treeMember);
                if (!resolvers.get(root.getUUID()).contains(resolver)) {
                    logger.debug((Object)("Registering resolver - Namespace:" + resolver.getNamespace() + " bound to node:" + treeMember.getName()));
                    resolvers.get(root.getUUID()).add(resolver);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregister(SPObject treeMember, SPVariableResolver resolver) {
        if (treeMember != null && resolver != null) {
            Map<String, List<SPVariableResolver>> map = resolvers;
            synchronized (map) {
                SPObject root = SPResolverRegistry.init(treeMember);
                logger.debug((Object)("Deregistering resolver - Namespace:" + resolver.getNamespace() + " bound to node:" + treeMember.getName()));
                resolvers.get(root.getUUID()).remove(resolver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SPVariableResolver> getResolvers(SPObject treeMember, String namespace) {
        if (treeMember == null) {
            return Collections.emptyList();
        }
        Map<String, List<SPVariableResolver>> map = resolvers;
        synchronized (map) {
            SPObject root = SPResolverRegistry.init(treeMember);
            if (root != null) {
                List<SPVariableResolver> registeredResolvers = resolvers.get(root.getUUID());
                ArrayList<SPVariableResolver> matches = new ArrayList<SPVariableResolver>();
                for (SPVariableResolver resolver : registeredResolvers) {
                    if (!resolver.resolvesNamespace(namespace)) continue;
                    matches.add(resolver);
                }
                return matches;
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SPVariableResolver getResolver(SPObject treeMember, String namespace) {
        if (treeMember == null) {
            return null;
        }
        Map<String, List<SPVariableResolver>> map = resolvers;
        synchronized (map) {
            SPObject root = SPResolverRegistry.init(treeMember);
            for (SPVariableResolver resolver : resolvers.get(root.getUUID())) {
                if (!resolver.resolvesNamespace(namespace)) continue;
                return resolver;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiValueMap getNamespaces(SPObject treeMember) {
        if (treeMember == null) {
            return new MultiValueMap();
        }
        Map<String, List<SPVariableResolver>> map = resolvers;
        synchronized (map) {
            MultiValueMap results = new MultiValueMap();
            SPObject root = SPResolverRegistry.init(treeMember);
            for (SPVariableResolver resolver : resolvers.get(root.getUUID())) {
                results.put((Object)resolver.getUserFriendlyName(), (Object)resolver.getNamespace());
            }
            return results;
        }
    }

    private static class TreeListener
    extends AbstractPoolingSPListener {
        private TreeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void propertyChangeImpl(PropertyChangeEvent e) {
            Map map = resolvers;
            synchronized (map) {
                if (e.getPropertyName().equalsIgnoreCase("uuid") && resolvers.containsKey(e.getOldValue())) {
                    resolvers.put((String)e.getNewValue(), resolvers.get(e.getOldValue()));
                    listeners.put((String)e.getNewValue(), listeners.get(e.getOldValue()));
                    resolvers.remove(e.getOldValue());
                    listeners.remove(e.getOldValue());
                }
            }
        }
    }
}

