/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.instruction;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.instruction.DexBackedInstruction;
import com.android.tools.smali.dexlib2.dexbacked.util.FixedSizeList;
import com.android.tools.smali.dexlib2.iface.instruction.SwitchElement;
import com.android.tools.smali.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import java.util.List;

public class DexBackedPackedSwitchPayload
extends DexBackedInstruction
implements PackedSwitchPayload {
    public final int elementCount;

    public DexBackedPackedSwitchPayload(DexBackedDexFile dexFile, int instructionStart) {
        super(dexFile, Opcode.PACKED_SWITCH_PAYLOAD, instructionStart);
        this.elementCount = dexFile.getDataBuffer().readUshort(instructionStart + 2);
    }

    @Override
    public List<? extends SwitchElement> getSwitchElements() {
        final int firstKey = this.dexFile.getDataBuffer().readInt(this.instructionStart + 4);
        return new FixedSizeList<SwitchElement>(){

            @Override
            public SwitchElement readItem(final int index) {
                return new SwitchElement(){

                    @Override
                    public int getKey() {
                        return firstKey + index;
                    }

                    @Override
                    public int getOffset() {
                        return DexBackedPackedSwitchPayload.this.dexFile.getDataBuffer().readInt(DexBackedPackedSwitchPayload.this.instructionStart + 8 + index * 4);
                    }
                };
            }

            @Override
            public int size() {
                return DexBackedPackedSwitchPayload.this.elementCount;
            }
        };
    }

    @Override
    public int getCodeUnits() {
        return 4 + this.elementCount * 2;
    }
}

