/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.util;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import java.math.BigInteger;
import java.util.List;

public class MathHelper {
    public static BigInteger intfloordiv(BigInteger c, BigInteger d) {
        return c.subtract(c.mod(d)).divide(d);
    }

    public static BigInteger intceildiv(BigInteger c, BigInteger d) {
        if (c.mod(d).equals(BigInteger.ZERO)) {
            return MathHelper.intfloordiv(c, d);
        }
        return MathHelper.intfloordiv(c, d).add(BigInteger.ONE);
    }

    public static int intfloordiv(int c, int d) {
        return (c - c % d) / d;
    }

    public static int intceildiv(int c, int d) {
        if (c % d == 0) {
            return MathHelper.intfloordiv(c, d);
        }
        return MathHelper.intfloordiv(c, d) + 1;
    }

    public static BigIntegerTripple extendedEuclid(BigInteger u, BigInteger v) {
        BigInteger r = BigInteger.ONE;
        BigInteger s = BigInteger.ZERO;
        BigInteger c = u;
        BigInteger v1 = BigInteger.ZERO;
        BigInteger v2 = BigInteger.ONE;
        BigInteger v3 = v;
        while (!v3.equals(BigInteger.ZERO)) {
            BigInteger q = c.divide(v3);
            BigInteger t1 = r.subtract(q.multiply(v1));
            BigInteger t2 = s.subtract(q.multiply(v2));
            BigInteger t3 = c.subtract(q.multiply(v3));
            r = v1;
            s = v2;
            c = v3;
            v1 = t1;
            v2 = t2;
            v3 = t3;
        }
        return new BigIntegerTripple(c, r, s);
    }

    public static BigInteger gcd(BigInteger u, BigInteger v) {
        return MathHelper.extendedEuclid(u, v).a;
    }

    public static BigInteger inverseMod(BigInteger a, BigInteger p) {
        if (!MathHelper.gcd(a, p).equals(BigInteger.ONE)) {
            throw new RuntimeException("does not exist");
        }
        BigInteger b = MathHelper.extendedEuclid(a, p).b;
        while (b.compareTo(BigInteger.ZERO) < 0) {
            b = b.add(p);
        }
        return b;
    }

    public static BigInteger CRT(BigInteger[] congs, BigInteger[] moduli) {
        BigInteger prodModuli = BigInteger.ONE;
        for (BigInteger mod : moduli) {
            prodModuli = prodModuli.multiply(mod);
        }
        BigInteger[] M = new BigInteger[moduli.length];
        for (int i = 0; i < moduli.length; ++i) {
            M[i] = prodModuli.divide(moduli[i]);
        }
        BigInteger retval = BigInteger.ZERO;
        for (int i = 0; i < moduli.length; ++i) {
            BigInteger tmp = MathHelper.extendedEuclid(moduli[i], M[i]).c;
            retval = retval.add(congs[i].multiply(tmp).multiply(M[i]).mod(prodModuli));
        }
        return retval.mod(prodModuli);
    }

    public static BigInteger CRT(List<BigInteger> congs, List<BigInteger> moduli) {
        BigInteger[] cs = ArrayConverter.convertListToArray(congs);
        BigInteger[] ms = ArrayConverter.convertListToArray(moduli);
        return MathHelper.CRT(cs, ms);
    }

    public static BigInteger bigIntSqRootFloor(BigInteger x) throws IllegalArgumentException {
        if (x.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Negative argument.");
        }
        if (x.equals(BigInteger.ZERO) || x.equals(BigInteger.ONE)) {
            return x;
        }
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger y = x.divide(two);
        while (y.compareTo(x.divide(y)) > 0) {
            y = x.divide(y).add(y).divide(two);
        }
        return y;
    }

    public static BigInteger bigIntSqRootCeil(BigInteger x) throws IllegalArgumentException {
        if (x.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Negative argument.");
        }
        if (x.equals(BigInteger.ZERO) || x.equals(BigInteger.ONE)) {
            return x;
        }
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger y = x.divide(two);
        while (y.compareTo(x.divide(y)) > 0) {
            y = x.divide(y).add(y).divide(two);
        }
        if (x.compareTo(y.multiply(y)) == 0) {
            return y;
        }
        return y.add(BigInteger.ONE);
    }

    private MathHelper() {
    }

    public static class BigIntegerTripple {
        private final BigInteger a;
        private final BigInteger b;
        private final BigInteger c;

        public BigIntegerTripple(BigInteger a, BigInteger b, BigInteger c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public BigInteger getA() {
            return this.a;
        }

        public BigInteger getB() {
            return this.b;
        }

        public BigInteger getC() {
            return this.c;
        }
    }
}

