/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.openide.explorer.TTVEnvBridge;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.TreeTable;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class TableSheetCell
extends AbstractCellEditor
implements TableModelListener,
PropertyChangeListener,
TableCellEditor,
TableCellRenderer {
    private NodeTableModel tableModel;
    private Boolean flat;
    private Node node;
    private Node.Property prop;
    private TableCellRenderer headerRenderer = new JTable().getTableHeader().getDefaultRenderer();
    private NullPanel nullPanel;
    private Map panelCache = new WeakHashMap();
    private FocusedPropertyPanel renderer = null;
    private PropertyPanel editor = null;

    public TableSheetCell(NodeTableModel nodeTableModel) {
        this.tableModel = nodeTableModel;
        this.setFlat(false);
    }

    public void setFlat(boolean bl) {
        Color color = Color.lightGray;
        if (UIManager.getColor("controlDkShadow") != null) {
            color = UIManager.getColor("controlDkShadow");
        }
        Color color2 = Color.black;
        if (UIManager.getColor("controlLtHighlight") != null) {
            color2 = UIManager.getColor("controlLtHighlight");
        }
        Color color3 = Color.blue;
        if (UIManager.getColor("Button.focus") != null) {
            color3 = UIManager.getColor("Button.focus");
        }
        this.flat = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getCellEditorValue() {
        return null;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.prop = (Node.Property)object;
        this.node = this.tableModel.nodeForRow(n);
        this.node.addPropertyChangeListener((PropertyChangeListener)this);
        this.tableModel.addTableModelListener(this);
        PropertyPanel propertyPanel = this.getEditor(this.prop, this.node);
        propertyPanel.setBackground(jTable.getSelectionBackground());
        propertyPanel.setForeground(jTable.getSelectionForeground());
        propertyPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, jTable.getSelectionBackground()));
        return propertyPanel;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.tableModel.fireTableDataChanged();
    }

    public boolean stopCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        return super.stopCellEditing();
    }

    public void cancelCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        super.cancelCellEditing();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.cancelCellEditing();
    }

    private void detachEditor() {
        this.node.removePropertyChangeListener((PropertyChangeListener)this);
        this.tableModel.removeTableModelListener(this);
        this.node = null;
        this.prop = null;
    }

    private FocusedPropertyPanel getRenderer(Node.Property property, Node node) {
        TTVEnvBridge tTVEnvBridge = TTVEnvBridge.getInstance(this);
        tTVEnvBridge.setCurrentBeans(new Node[]{node});
        if (this.renderer == null) {
            this.renderer = new FocusedPropertyPanel(property, 9);
            this.renderer.putClientProperty("beanBridgeIdentifier", this);
        }
        this.renderer.setProperty(property);
        this.renderer.putClientProperty("flat", Boolean.TRUE);
        return this.renderer;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n == -1) {
            Component component = this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JComponent) {
                String string = n2 > 0 ? this.tableModel.propertyForColumn(n2).getShortDescription() : jTable.getColumnName(0);
                ((JComponent)component).setToolTipText(string);
            }
            return component;
        }
        Node.Property property = (Node.Property)object;
        Node node = this.tableModel.nodeForRow(n);
        if (property != null) {
            Object object2;
            FocusedPropertyPanel focusedPropertyPanel = this.getRenderer(property, node);
            focusedPropertyPanel.setFocused(bl2);
            String string = null;
            try {
                object2 = property.getValue();
                if (null != object2) {
                    string = object2.toString();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(TableSheetCell.class.getName()).log(Level.WARNING, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(TableSheetCell.class.getName()).log(Level.WARNING, null, invocationTargetException);
            }
            focusedPropertyPanel.setToolTipText(TableSheetCell.createHtmlTooltip(string, focusedPropertyPanel.getFont()));
            focusedPropertyPanel.setOpaque(true);
            if (bl) {
                boolean bl3;
                object2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean bl4 = bl3 = jTable == object2 || jTable.isAncestorOf((Component)object2) || object2 instanceof Container && ((Container)object2).isAncestorOf(jTable);
                if (jTable == object2 && jTable.isEditing()) {
                    bl3 = true;
                }
                focusedPropertyPanel.setBackground(bl3 ? jTable.getSelectionBackground() : TreeTable.getUnfocusedSelectedBackground());
                focusedPropertyPanel.setForeground(bl3 ? jTable.getSelectionForeground() : TreeTable.getUnfocusedSelectedForeground());
            } else {
                focusedPropertyPanel.setBackground(jTable.getBackground());
                focusedPropertyPanel.setForeground(jTable.getForeground());
            }
            return focusedPropertyPanel;
        }
        if (this.nullPanel == null) {
            this.nullPanel = new NullPanel(node);
            this.nullPanel.setOpaque(true);
        } else {
            this.nullPanel.setNode(node);
        }
        if (bl) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            boolean bl5 = bl2 || jTable == component || jTable.isAncestorOf(component) || component instanceof Container && ((Container)component).isAncestorOf(jTable);
            this.nullPanel.setBackground(bl5 ? jTable.getSelectionBackground() : TreeTable.getUnfocusedSelectedBackground());
            this.nullPanel.setForeground(jTable.getSelectionForeground().darker());
        } else {
            this.nullPanel.setBackground(jTable.getBackground());
            this.nullPanel.setForeground(jTable.getForeground());
        }
        this.nullPanel.setFocused(bl2);
        return this.nullPanel;
    }

    private PropertyPanel getEditor(Node.Property property, Node node) {
        int n = 8;
        TTVEnvBridge tTVEnvBridge = TTVEnvBridge.getInstance(this);
        tTVEnvBridge.setCurrentBeans(new Node[]{node});
        if (this.editor == null) {
            this.editor = new PropertyPanel(property, n);
            this.editor.putClientProperty("flat", Boolean.TRUE);
            this.editor.putClientProperty("beanBridgeIdentifier", this);
            this.editor.setProperty(property);
            return this.editor;
        }
        this.editor.setProperty(property);
        return this.editor;
    }

    void updateUI() {
        this.headerRenderer = new JTable().getTableHeader().getDefaultRenderer();
    }

    private static String getString(String string) {
        return NbBundle.getBundle(TableSheetCell.class).getString(string);
    }

    static String createHtmlTooltip(String string, Font font) {
        if (string == null) {
            return "null";
        }
        String string2 = null;
        if (string.indexOf(" ") != -1) {
            string2 = " ";
        } else if (string.indexOf(",") != -1) {
            string2 = ",";
        } else if (string.indexOf(";") != -1) {
            string2 = ";";
        } else if (string.indexOf("/") != -1) {
            string2 = "/";
        } else if (string.indexOf(">") != -1) {
            string2 = ">";
        } else if (string.indexOf("\\") != -1) {
            string2 = "\\";
        } else {
            return TableSheetCell.makeDisplayble(string, font);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        stringBuffer.append("<html>");
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string3 = TableSheetCell.makeDisplayble(string3, font);
            n += string3.length();
            stringBuffer.append(string3);
            if (stringTokenizer.hasMoreTokens()) {
                ++n;
            }
            if (n <= 80) continue;
            stringBuffer.append("<br>");
            n = 0;
            if (++n2 <= 10) continue;
            stringBuffer.append(NbBundle.getMessage(TableSheetCell.class, (String)"MSG_ELLIPSIS"));
            return stringBuffer.toString();
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private static String makeDisplayble(String string, Font font) {
        if (null == string) {
            return string;
        }
        if (null == font) {
            font = new JLabel().getFont();
        }
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.3));
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\t': {
                    stringBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue block7;
                }
                case '\n': {
                    continue block7;
                }
                case '\r': {
                    continue block7;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block7;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block7;
                }
                default: {
                    if (TableSheetCell.processHtmlEntity(stringBuffer, c)) continue block7;
                    if (null == font || font.canDisplay(c)) {
                        stringBuffer.append(c);
                        continue block7;
                    }
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static boolean processHtmlEntity(StringBuffer stringBuffer, char c) {
        switch (c) {
            case '>': {
                stringBuffer.append("&gt;");
                break;
            }
            case '<': {
                stringBuffer.append("&lt;");
                break;
            }
            case '&': {
                stringBuffer.append("&amp;");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static class FocusedPropertyPanel
    extends PropertyPanel {
        boolean focused;

        public FocusedPropertyPanel(Node.Property property, int n) {
            super(property, n);
        }

        public void setFocused(boolean bl) {
            this.focused = bl;
        }

        public String getToolTipText() {
            String string = super.getToolTipText();
            String string2 = this.getProperty().getShortDescription();
            if (string2 != null) {
                return string2;
            }
            return string;
        }

        public void addComponentListener(ComponentListener componentListener) {
        }

        public void addHierarchyListener(HierarchyListener hierarchyListener) {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void revalidate() {
        }

        public void firePropertyChange(String string, Object object, Object object2) {
            if ("flat".equals(string)) {
                super.firePropertyChange(string, object, object2);
            }
        }

        public boolean isShowing() {
            return true;
        }

        public void update(Graphics graphics) {
        }

        public void paint(Graphics graphics) {
            Color color = this.getBackground();
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(color2);
            super.paint(graphics);
            if (this.focused) {
                Color color3 = UIManager.getColor("Tree.selectionBorderColor");
                if (color3 == null) {
                    color3 = this.getForeground().equals(Color.BLACK) ? this.getBackground().darker() : this.getForeground().darker();
                }
                graphics.setColor(color3);
                graphics.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            }
            graphics.setColor(color2);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleFocusedPropertyPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleFocusedPropertyPanel
        extends JComponent.AccessibleJComponent {
            AccessibleFocusedPropertyPanel() {
                super(FocusedPropertyPanel.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }

            public String getAccessibleName() {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                PropertyEditor propertyEditor = FocusedPropertyPanel.this.getPropertyEditor();
                return MessageFormat.format(TableSheetCell.getString("ACS_PropertyPanelRenderer"), featureDescriptor.getDisplayName(), propertyEditor == null ? TableSheetCell.getString("CTL_No_value") : propertyEditor.getAsText());
            }

            public String getAccessibleDescription() {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                Node node = (Node)((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getBeans()[0];
                Class clazz = FocusedPropertyPanel.this.getModel().getPropertyType();
                return MessageFormat.format(TableSheetCell.getString("ACSD_PropertyPanelRenderer"), featureDescriptor.getShortDescription(), clazz == null ? TableSheetCell.getString("CTL_No_type") : clazz.getName(), node.getDisplayName());
            }
        }
    }

    private static class NullPanel
    extends JPanel {
        private Reference<Node> weakNode;
        private boolean focused = false;

        NullPanel(Node node) {
            this.weakNode = new WeakReference<Node>(node);
        }

        void setNode(Node node) {
            this.weakNode = new WeakReference<Node>(node);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleNullPanel();
            }
            return this.accessibleContext;
        }

        public void setFocused(boolean bl) {
            this.focused = bl;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.focused) {
                Color color = UIManager.getColor("Tree.selectionBorderColor");
                if (color == null) {
                    color = this.getForeground().equals(Color.BLACK) ? this.getBackground().darker() : this.getForeground().darker();
                }
                graphics.setColor(color);
                graphics.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
                graphics.setColor(color);
            }
        }

        public void addComponentListener(ComponentListener componentListener) {
        }

        public void addHierarchyListener(HierarchyListener hierarchyListener) {
        }

        public void repaint() {
        }

        public void repaint(int n, int n2, int n3, int n4) {
        }

        public void invalidate() {
        }

        public void revalidate() {
        }

        public void validate() {
        }

        public void firePropertyChange(String string, Object object, Object object2) {
        }

        private class AccessibleNullPanel
        extends JPanel.AccessibleJPanel {
            AccessibleNullPanel() {
                super(NullPanel.this);
            }

            public String getAccessibleName() {
                String string = super.getAccessibleName();
                if (string == null) {
                    string = TableSheetCell.getString("ACS_NullPanel");
                }
                return string;
            }

            public String getAccessibleDescription() {
                Node node;
                String string = super.getAccessibleDescription();
                if (string == null && (node = (Node)NullPanel.this.weakNode.get()) != null) {
                    string = MessageFormat.format(TableSheetCell.getString("ACSD_NullPanel"), node.getDisplayName());
                }
                return string;
            }
        }
    }
}

