/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * min(ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0)) => ivec4(-5, -5, -5, -5)
 * min(ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5)) => ivec4(-5, -5, -5, -5)
 * min(ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1)) => ivec4(-2, -2, -2, -2)
 * min(ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2)) => ivec4(-2, -2, -5, -2)
 * min(ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2)) => ivec4(-1, -1, -1, -1)
 * min(ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1)) => ivec4(-1, -5, -2, -1)
 * min(ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5)) => ivec4(0, 0, 0, 0)
 * min(ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0)) => ivec4(-5, -2, -1, 0)
 * min(ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5)) => ivec4(1, 1, 1, -5)
 * min(ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1)) => ivec4(-2, -1, 0, 1)
 * min(ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2)) => ivec4(2, 2, -5, -2)
 * min(ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2)) => ivec4(-1, 0, 1, 2)
 * min(ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1)) => ivec4(5, -5, -5, -5)
 */
#version 130

void main()
{
  float[all(equal(min(ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array0;
  float[all(equal(min(ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5)), ivec4(-5, -5, -5, -5))) ? 1 : -1] array1;
  float[all(equal(min(ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1)), ivec4(-2, -2, -2, -2))) ? 1 : -1] array2;
  float[all(equal(min(ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2)), ivec4(-2, -2, -5, -2))) ? 1 : -1] array3;
  float[all(equal(min(ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2)), ivec4(-1, -1, -1, -1))) ? 1 : -1] array4;
  float[all(equal(min(ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1)), ivec4(-1, -5, -2, -1))) ? 1 : -1] array5;
  float[all(equal(min(ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5)), ivec4(0, 0, 0, 0))) ? 1 : -1] array6;
  float[all(equal(min(ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0)), ivec4(-5, -2, -1, 0))) ? 1 : -1] array7;
  float[all(equal(min(ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5)), ivec4(1, 1, 1, -5))) ? 1 : -1] array8;
  float[all(equal(min(ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1)), ivec4(-2, -1, 0, 1))) ? 1 : -1] array9;
  float[all(equal(min(ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2)), ivec4(2, 2, -5, -2))) ? 1 : -1] array10;
  float[all(equal(min(ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2)), ivec4(-1, 0, 1, 2))) ? 1 : -1] array11;
  float[all(equal(min(ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1)), ivec4(5, -5, -5, -5))) ? 1 : -1] array12;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length());
}
