/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class FromUnixTimeFunction
extends ImplementorUDF {
    public FromUnixTimeFunction() {
        super(new FromUnixTimeImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return opBinding -> {
            if (opBinding.collectOperandTypes().size() == 1) {
                return UserDefinedFunctionUtils.NULLABLE_TIMESTAMP_UDT;
            }
            return UserDefinedFunctionUtils.NULLABLE_STRING;
        };
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.NUMERIC_OPTIONAL_STRING;
    }

    public static class FromUnixTimeImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.call(FromUnixTimeImplementor.class, (String)"fromUnixTime", translatedOperands);
        }

        public static String fromUnixTime(double unixTime) {
            return (String)DateTimeFunctions.exprFromUnixTime(new ExprDoubleValue(unixTime)).valueForCalcite();
        }

        public static String fromUnixTime(BigDecimal unixTime) {
            return (String)DateTimeFunctions.exprFromUnixTime(new ExprDoubleValue(unixTime)).valueForCalcite();
        }

        public static String fromUnixTime(double unixTime, String format) {
            return (String)DateTimeFunctions.exprFromUnixTimeFormat(new ExprDoubleValue(unixTime), new ExprStringValue(format)).valueForCalcite();
        }
    }
}

