/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.QueryBreakdown;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class QueryProfile
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, QueryProfile> {
    @Nonnull
    private final QueryBreakdown breakdown;
    @Nonnull
    private final List<QueryProfile> children;
    @Nonnull
    private final String description;
    private final long timeInNanos;
    @Nonnull
    private final String type;
    public static final JsonpDeserializer<QueryProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryProfile::setupQueryProfileDeserializer);

    private QueryProfile(Builder builder) {
        this.breakdown = ApiTypeHelper.requireNonNull(builder.breakdown, this, "breakdown");
        this.children = ApiTypeHelper.unmodifiable(builder.children);
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.timeInNanos = ApiTypeHelper.requireNonNull(builder.timeInNanos, this, "timeInNanos");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static QueryProfile of(Function<Builder, ObjectBuilder<QueryProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final QueryBreakdown breakdown() {
        return this.breakdown;
    }

    @Nonnull
    public final List<QueryProfile> children() {
        return this.children;
    }

    @Nonnull
    public final String description() {
        return this.description;
    }

    public final long timeInNanos() {
        return this.timeInNanos;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("breakdown");
        this.breakdown.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (QueryProfile item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        generator.writeKey("type");
        generator.write(this.type);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupQueryProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::breakdown, QueryBreakdown._DESERIALIZER, "breakdown");
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.breakdown.hashCode();
        result = 31 * result + Objects.hashCode(this.children);
        result = 31 * result + this.description.hashCode();
        result = 31 * result + Long.hashCode(this.timeInNanos);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryProfile other = (QueryProfile)o;
        return this.breakdown.equals(other.breakdown) && Objects.equals(this.children, other.children) && this.description.equals(other.description) && this.timeInNanos == other.timeInNanos && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, QueryProfile> {
        private QueryBreakdown breakdown;
        @Nullable
        private List<QueryProfile> children;
        private String description;
        private Long timeInNanos;
        private String type;

        public Builder() {
        }

        private Builder(QueryProfile o) {
            this.breakdown = o.breakdown;
            this.children = Builder._listCopy(o.children);
            this.description = o.description;
            this.timeInNanos = o.timeInNanos;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.breakdown = o.breakdown;
            this.children = Builder._listCopy(o.children);
            this.description = o.description;
            this.timeInNanos = o.timeInNanos;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder breakdown(QueryBreakdown value) {
            this.breakdown = value;
            return this;
        }

        @Nonnull
        public final Builder breakdown(Function<QueryBreakdown.Builder, ObjectBuilder<QueryBreakdown>> fn) {
            return this.breakdown(fn.apply(new QueryBreakdown.Builder()).build());
        }

        @Nonnull
        public final Builder children(List<QueryProfile> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        @Nonnull
        public final Builder children(QueryProfile value, QueryProfile ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        @Nonnull
        public final Builder children(Function<Builder, ObjectBuilder<QueryProfile>> fn) {
            return this.children(fn.apply(new Builder()).build(), new QueryProfile[0]);
        }

        @Nonnull
        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        @Nonnull
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public QueryProfile build() {
            this._checkSingleUse();
            return new QueryProfile(this);
        }
    }
}

