/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.WorkflowStepValidator;
import org.opensearch.flowframework.model.WorkflowValidator;
import org.opensearch.flowframework.workflow.CreateConnectorStep;
import org.opensearch.flowframework.workflow.CreateIndexStep;
import org.opensearch.flowframework.workflow.CreateIngestPipelineStep;
import org.opensearch.flowframework.workflow.CreateSearchPipelineStep;
import org.opensearch.flowframework.workflow.DeleteAgentStep;
import org.opensearch.flowframework.workflow.DeleteConnectorStep;
import org.opensearch.flowframework.workflow.DeleteIndexStep;
import org.opensearch.flowframework.workflow.DeleteIngestPipelineStep;
import org.opensearch.flowframework.workflow.DeleteModelStep;
import org.opensearch.flowframework.workflow.DeleteSearchPipelineStep;
import org.opensearch.flowframework.workflow.DeployModelStep;
import org.opensearch.flowframework.workflow.NoOpStep;
import org.opensearch.flowframework.workflow.RegisterAgentStep;
import org.opensearch.flowframework.workflow.RegisterLocalCustomModelStep;
import org.opensearch.flowframework.workflow.RegisterLocalPretrainedModelStep;
import org.opensearch.flowframework.workflow.RegisterLocalSparseEncodingModelStep;
import org.opensearch.flowframework.workflow.RegisterModelGroupStep;
import org.opensearch.flowframework.workflow.RegisterRemoteModelStep;
import org.opensearch.flowframework.workflow.ReindexStep;
import org.opensearch.flowframework.workflow.ToolStep;
import org.opensearch.flowframework.workflow.UndeployModelStep;
import org.opensearch.flowframework.workflow.UpdateIndexStep;
import org.opensearch.flowframework.workflow.UpdateIngestPipelineStep;
import org.opensearch.flowframework.workflow.UpdateSearchPipelineStep;
import org.opensearch.flowframework.workflow.WorkflowProcessSorter;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class WorkflowStepFactory {
    private final Map<String, Supplier<WorkflowStep>> stepMap = new HashMap<String, Supplier<WorkflowStep>>();
    private static final Logger logger = LogManager.getLogger(WorkflowStepFactory.class);

    public WorkflowStepFactory(ThreadPool threadPool, MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings, Client client) {
        this.stepMap.put("noop", NoOpStep::new);
        this.stepMap.put("create_index", () -> new CreateIndexStep(client, flowFrameworkIndicesHandler));
        this.stepMap.put("delete_index", () -> new DeleteIndexStep(client));
        this.stepMap.put("reindex", () -> new ReindexStep(client, flowFrameworkIndicesHandler));
        this.stepMap.put("register_local_custom_model", () -> new RegisterLocalCustomModelStep(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings));
        this.stepMap.put("register_local_sparse_encoding_model", () -> new RegisterLocalSparseEncodingModelStep(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings));
        this.stepMap.put("register_local_pretrained_model", () -> new RegisterLocalPretrainedModelStep(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings));
        this.stepMap.put("register_remote_model", () -> new RegisterRemoteModelStep(mlClient, flowFrameworkIndicesHandler));
        this.stepMap.put("delete_model", () -> new DeleteModelStep(mlClient));
        this.stepMap.put("deploy_model", () -> new DeployModelStep(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings));
        this.stepMap.put("undeploy_model", () -> new UndeployModelStep(mlClient));
        this.stepMap.put("create_connector", () -> new CreateConnectorStep(mlClient, flowFrameworkIndicesHandler));
        this.stepMap.put("delete_connector", () -> new DeleteConnectorStep(mlClient));
        this.stepMap.put("register_model_group", () -> new RegisterModelGroupStep(mlClient, flowFrameworkIndicesHandler));
        this.stepMap.put("create_tool", ToolStep::new);
        this.stepMap.put("register_agent", () -> new RegisterAgentStep(mlClient, flowFrameworkIndicesHandler));
        this.stepMap.put("delete_agent", () -> new DeleteAgentStep(mlClient));
        this.stepMap.put("create_ingest_pipeline", () -> new CreateIngestPipelineStep(client, flowFrameworkIndicesHandler));
        this.stepMap.put("delete_ingest_pipeline", () -> new DeleteIngestPipelineStep(client));
        this.stepMap.put("create_search_pipeline", () -> new CreateSearchPipelineStep(client, flowFrameworkIndicesHandler));
        this.stepMap.put("update_ingest_pipeline", () -> new UpdateIngestPipelineStep(client));
        this.stepMap.put("update_search_pipeline", () -> new UpdateSearchPipelineStep(client));
        this.stepMap.put("update_index", () -> new UpdateIndexStep(client));
        this.stepMap.put("delete_search_pipeline", () -> new DeleteSearchPipelineStep(client));
    }

    public WorkflowValidator getWorkflowValidator() {
        return new WorkflowValidator(Stream.of(WorkflowSteps.values()).filter(w -> !WorkflowProcessSorter.WORKFLOW_STEP_DENYLIST.contains(w.getWorkflowStepName())).collect(Collectors.toMap(WorkflowSteps::getWorkflowStepName, WorkflowSteps::getWorkflowStepValidator)));
    }

    public WorkflowValidator getWorkflowValidatorByStep(List<String> steps) {
        Set validSteps = Stream.of(WorkflowSteps.values()).map(WorkflowSteps::getWorkflowStepName).filter(name -> !WorkflowProcessSorter.WORKFLOW_STEP_DENYLIST.contains(name)).filter(steps::contains).collect(Collectors.toSet());
        Set invalidSteps = steps.stream().filter(name -> !validSteps.contains(name)).collect(Collectors.toSet());
        if (!invalidSteps.isEmpty()) {
            throw new FlowFrameworkException("Invalid step name: " + String.valueOf(invalidSteps), RestStatus.BAD_REQUEST);
        }
        return new WorkflowValidator(Stream.of(WorkflowSteps.values()).filter(w -> validSteps.contains(w.getWorkflowStepName())).collect(Collectors.toMap(WorkflowSteps::getWorkflowStepName, WorkflowSteps::getWorkflowStepValidator)));
    }

    public WorkflowStep createStep(String type) {
        if (this.stepMap.containsKey(type)) {
            return this.stepMap.get(type).get();
        }
        throw new FlowFrameworkException("Workflow step type [" + type + "] is not implemented.", RestStatus.NOT_IMPLEMENTED);
    }

    public Map<String, Supplier<WorkflowStep>> getStepMap() {
        return Map.copyOf(this.stepMap);
    }

    public static enum WorkflowSteps {
        NOOP("noop", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null),
        CREATE_INDEX("create_index", List.of("index_name", "configurations"), List.of("index_name"), Collections.emptyList(), null),
        DELETE_INDEX("delete_index", DeleteIndexStep.REQUIRED_INPUTS, DeleteIndexStep.PROVIDED_OUTPUTS, Collections.emptyList(), null),
        REINDEX("reindex", List.of("source_index", "destination_index"), List.of("reindex"), Collections.emptyList(), null),
        CREATE_CONNECTOR("create_connector", List.of("name", "description", "version", "protocol", "parameters", "credential", "actions"), List.of("connector_id"), List.of("opensearch-ml"), TimeValue.timeValueSeconds((long)60L)),
        REGISTER_LOCAL_CUSTOM_MODEL("register_local_custom_model", List.of("name", "version", "model_format", "function_name", "model_content_hash_value", "url", "model_type", "embedding_dimension", "framework_type"), List.of("model_id", "register_model_status"), List.of("opensearch-ml"), TimeValue.timeValueSeconds((long)60L)),
        REGISTER_LOCAL_SPARSE_ENCODING_MODEL("register_local_sparse_encoding_model", List.of("name", "version", "model_format"), List.of("model_id", "register_model_status", "function_name", "model_content_hash_value", "url"), List.of("opensearch-ml"), TimeValue.timeValueSeconds((long)60L)),
        REGISTER_LOCAL_PRETRAINED_MODEL("register_local_pretrained_model", List.of("name", "version", "model_format"), List.of("model_id", "register_model_status"), List.of("opensearch-ml"), TimeValue.timeValueSeconds((long)60L)),
        REGISTER_REMOTE_MODEL("register_remote_model", List.of("name", "connector_id"), List.of("model_id", "register_model_status"), List.of("opensearch-ml"), null),
        REGISTER_MODEL_GROUP("register_model_group", List.of("name"), List.of("model_group_id", "model_group_status"), List.of("opensearch-ml"), null),
        DEPLOY_MODEL("deploy_model", List.of("model_id"), List.of("model_id"), List.of("opensearch-ml"), TimeValue.timeValueSeconds((long)15L)),
        UNDEPLOY_MODEL("undeploy_model", List.of("model_id"), List.of("success"), List.of("opensearch-ml"), null),
        DELETE_MODEL("delete_model", List.of("model_id"), List.of("model_id"), List.of("opensearch-ml"), null),
        DELETE_CONNECTOR("delete_connector", List.of("connector_id"), List.of("connector_id"), List.of("opensearch-ml"), null),
        REGISTER_AGENT("register_agent", List.of("name", "type"), List.of("agent_id"), List.of("opensearch-ml"), null),
        DELETE_AGENT("delete_agent", List.of("agent_id"), List.of("agent_id"), List.of("opensearch-ml"), null),
        CREATE_TOOL("create_tool", ToolStep.REQUIRED_INPUTS, ToolStep.PROVIDED_OUTPUTS, List.of("opensearch-ml"), null),
        CREATE_INGEST_PIPELINE("create_ingest_pipeline", List.of("pipeline_id", "configurations"), List.of("pipeline_id"), Collections.emptyList(), null),
        DELETE_INGEST_PIPELINE("delete_ingest_pipeline", DeleteIngestPipelineStep.REQUIRED_INPUTS, DeleteIngestPipelineStep.PROVIDED_OUTPUTS, Collections.emptyList(), null),
        CREATE_SEARCH_PIPELINE("create_search_pipeline", List.of("pipeline_id", "configurations"), List.of("pipeline_id"), Collections.emptyList(), null),
        UPDATE_INGEST_PIPELINE("update_ingest_pipeline", List.of("pipeline_id", "configurations"), List.of("pipeline_id"), Collections.emptyList(), null),
        UPDATE_SEARCH_PIPELINE("update_search_pipeline", List.of("pipeline_id", "configurations"), List.of("pipeline_id"), Collections.emptyList(), null),
        UPDATE_INDEX("update_index", List.of("index_name", "configurations"), List.of("index_name"), Collections.emptyList(), null),
        DELETE_SEARCH_PIPELINE("delete_search_pipeline", DeleteSearchPipelineStep.REQUIRED_INPUTS, DeleteSearchPipelineStep.PROVIDED_OUTPUTS, Collections.emptyList(), null);

        private final String workflowStepName;
        private final List<String> inputs;
        private final List<String> outputs;
        private final List<String> requiredPlugins;
        private final TimeValue timeout;

        private WorkflowSteps(String workflowStepName, Collection<String> inputs, Collection<String> outputs, List<String> requiredPlugins, TimeValue timeout) {
            this.workflowStepName = workflowStepName;
            this.inputs = List.copyOf(inputs);
            this.outputs = List.copyOf(outputs);
            this.requiredPlugins = requiredPlugins;
            this.timeout = timeout;
        }

        public String getWorkflowStepName() {
            return this.workflowStepName;
        }

        public List<String> inputs() {
            return this.inputs;
        }

        public List<String> outputs() {
            return this.outputs;
        }

        public List<String> requiredPlugins() {
            return this.requiredPlugins;
        }

        public TimeValue timeout() {
            return this.timeout;
        }

        public WorkflowStepValidator getWorkflowStepValidator() {
            return new WorkflowStepValidator(this.inputs, this.outputs, this.requiredPlugins, this.timeout);
        }

        public static TimeValue getTimeoutByWorkflowType(String workflowStep) throws FlowFrameworkException {
            if (!Strings.isNullOrEmpty((String)workflowStep)) {
                for (WorkflowSteps mapping : WorkflowSteps.values()) {
                    if (!workflowStep.equals(mapping.getWorkflowStepName())) continue;
                    return mapping.timeout();
                }
            }
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Unable to find workflow timeout for step: {}", (Object)workflowStep).getFormattedMessage();
            logger.error(errorMessage);
            throw new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
        }

        public static List<String> getRequiredPluginsByWorkflowType(String workflowStep) throws FlowFrameworkException {
            if (!Strings.isNullOrEmpty((String)workflowStep)) {
                for (WorkflowSteps mapping : WorkflowSteps.values()) {
                    if (!workflowStep.equals(mapping.getWorkflowStepName())) continue;
                    return mapping.requiredPlugins();
                }
            }
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Unable to find workflow required plugins for step: {}", (Object)workflowStep).getFormattedMessage();
            logger.error(errorMessage);
            throw new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
        }

        public static List<String> getOutputByWorkflowType(String workflowStep) throws FlowFrameworkException {
            if (!Strings.isNullOrEmpty((String)workflowStep)) {
                for (WorkflowSteps mapping : WorkflowSteps.values()) {
                    if (!workflowStep.equals(mapping.getWorkflowStepName())) continue;
                    return mapping.outputs();
                }
            }
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Unable to find workflow output for step {}", (Object)workflowStep).getFormattedMessage();
            logger.error(errorMessage);
            throw new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
        }

        public static List<String> getInputByWorkflowType(String workflowStep) throws FlowFrameworkException {
            if (!Strings.isNullOrEmpty((String)workflowStep)) {
                for (WorkflowSteps mapping : WorkflowSteps.values()) {
                    if (!workflowStep.equals(mapping.getWorkflowStepName())) continue;
                    return mapping.inputs();
                }
            }
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Unable to find workflow input for step: {}", (Object)workflowStep).getFormattedMessage();
            logger.error(errorMessage);
            throw new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
        }
    }
}

