/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.shared.common.error.StandardException;

abstract class SingleChildResultSetNode
extends FromTable {
    ResultSetNode childResult;
    protected boolean hasTrulyTheBestAccessPath;

    SingleChildResultSetNode(ResultSetNode childResult, Properties tableProperties, ContextManager cm) {
        super(null, tableProperties, cm);
        this.childResult = childResult;
        if (childResult.getReferencedTableMap() != null) {
            this.setReferencedTableMap((JBitSet)childResult.getReferencedTableMap().clone());
        }
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        if (this.hasTrulyTheBestAccessPath) {
            return super.getTrulyTheBestAccessPath();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
        }
        return super.getTrulyTheBestAccessPath();
    }

    ResultSetNode getChildResult() {
        return this.childResult;
    }

    void setChildResult(ResultSetNode childResult) {
        this.childResult = childResult;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).pullOptPredicates(optimizablePredicates);
        }
    }

    @Override
    public boolean forUpdate() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).forUpdate();
        }
        return super.forUpdate();
    }

    @Override
    public void initAccessPaths(Optimizer optimizer) {
        super.initAccessPaths(optimizer);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).initAccessPaths(optimizer);
        }
    }

    @Override
    public void updateBestPlanMap(short action, Object planKey) throws StandardException {
        super.updateBestPlanMap(action, planKey);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).updateBestPlanMap(action, planKey);
        } else if (this.childResult.getOptimizerImpl() != null) {
            this.childResult.getOptimizerImpl().updateBestPlanMaps(action, planKey);
        }
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.childResult != null) {
            this.printLabel(depth, "childResult: ");
            this.childResult.treePrint(depth + 1);
        }
    }

    @Override
    boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return this.childResult.referencesTarget(name, baseTable);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.childResult.referencesSessionSchema();
    }

    @Override
    void setLevel(int level) {
        super.setLevel(level);
        if (this.childResult instanceof FromTable) {
            ((FromTable)this.childResult).setLevel(level);
        }
    }

    @Override
    boolean subqueryReferencesTarget(String name, boolean baseTable) throws StandardException {
        return this.childResult.subqueryReferencesTarget(name, baseTable);
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.childResult = this.childResult.preprocess(numTables, gbl, fromList);
        this.setReferencedTableMap((JBitSet)this.childResult.getReferencedTableMap().clone());
        return this;
    }

    @Override
    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.childResult = this.childResult.addNewPredicate(predicate);
        return this;
    }

    @Override
    void pushExpressions(PredicateList predicateList) throws StandardException {
        if (this.childResult instanceof FromTable) {
            ((FromTable)this.childResult).pushExpressions(predicateList);
        }
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, predicates, outerRows);
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        this.childResult = this.childResult.modifyAccessPaths();
        return this;
    }

    @Override
    ResultSetNode changeAccessPath() throws StandardException {
        this.childResult = this.childResult.changeAccessPath();
        return this;
    }

    @Override
    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.childResult.getFromTableByName(name, schemaName, exactMatch);
    }

    @Override
    void decrementLevel(int decrement) {
        super.decrementLevel(decrement);
        this.childResult.decrementLevel(decrement);
    }

    @Override
    int updateTargetLockMode() {
        return this.childResult.updateTargetLockMode();
    }

    @Override
    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, List<FromBaseTable> fbtHolder) throws StandardException {
        return this.childResult.isOrderedOn(crs, permuteOrdering, fbtHolder);
    }

    @Override
    boolean isOneRowResultSet() throws StandardException {
        return this.childResult.isOneRowResultSet();
    }

    @Override
    boolean isNotExists() {
        return this.childResult.isNotExists();
    }

    protected boolean reflectionNeededForProjection() {
        return !this.getResultColumns().allExpressionsAreColumns(this.childResult);
    }

    @Override
    void adjustForSortElimination() {
        this.childResult.adjustForSortElimination();
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering rowOrdering) throws StandardException {
        this.childResult.adjustForSortElimination(rowOrdering);
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCostEstimate() == null) {
            return this.childResult.getFinalCostEstimate();
        }
        return this.getCostEstimate();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.childResult != null) {
            this.childResult = (ResultSetNode)this.childResult.accept(v);
        }
    }
}

