/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class NextSequenceNode
extends ValueNode {
    private TableName sequenceName;
    private SequenceDescriptor sequenceDescriptor;

    NextSequenceNode(TableName sequenceName, ContextManager cm) {
        super(cm);
        this.sequenceName = sequenceName;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates, boolean forQueryRewrite) throws StandardException {
        if (this.sequenceDescriptor != null) {
            return this;
        }
        CompilerContext cc = this.getCompilerContext();
        if ((cc.getReliability() & 0x4000) != 0) {
            throw StandardException.newException((String)"42XAH", (Object[])new Object[0]);
        }
        this.sequenceName.bind();
        SchemaDescriptor sd = this.getSchemaDescriptor(this.sequenceName.getSchemaName());
        this.sequenceDescriptor = this.getDataDictionary().getSequenceDescriptor(sd, this.sequenceName.getTableName());
        if (this.sequenceDescriptor == null) {
            throw StandardException.newException((String)"42X94", (Object[])new Object[]{"SEQUENCE", this.sequenceName.getFullTableName()});
        }
        if (sd.isSystemSchema()) {
            throw StandardException.newException((String)"42XAR", (Object[])new Object[0]);
        }
        this.setType(this.sequenceDescriptor.getDataType());
        if (cc.isReferenced(this.sequenceDescriptor)) {
            throw StandardException.newException((String)"42XAI", (Object[])new Object[]{this.sequenceName.getFullTableName()});
        }
        cc.addReferencedSequence(this.sequenceDescriptor);
        NextSequenceNode returnNode = this;
        this.getCompilerContext().createDependency(this.sequenceDescriptor);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredUsagePriv(this.sequenceDescriptor);
        }
        return returnNode;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        String sequenceUUIDstring = this.sequenceDescriptor.getUUID().toString();
        int dataTypeFormatID = this.sequenceDescriptor.getDataType().getNull().getTypeFormatId();
        mb.pushThis();
        mb.push(sequenceUUIDstring);
        mb.push(dataTypeFormatID);
        mb.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getCurrentValueAndAdvance", "org.apache.derby.iapi.types.NumberDataValue", 2);
    }

    void generateConstant(ExpressionClassBuilder ecb, MethodBuilder mb) throws StandardException {
        switch (this.getTypeServices().getJDBCTypeId()) {
            case 4: {
                mb.push(1);
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unexpected dataType = " + this.getTypeServices().getJDBCTypeId()));
            }
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    boolean isEquivalent(ValueNode other) throws StandardException {
        return false;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.sequenceName != null) {
            this.sequenceName = (TableName)this.sequenceName.accept(v);
        }
    }
}

